/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.dependencyAnalysis;

import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.Atom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DependencyAnalysis {
    static ClassLoaderReference generalClassLoaderRef = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom((String)"General"), ClassLoaderReference.Java, ClassLoaderReference.Application);

    public static DAClassInfo findDependancy(ModuleEntry m) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        ClassReader cr = new ShrikeClassReaderHandle(m).get();
        DAClassInfo ret = new DAClassInfo(DependencyAnalysis.typeStringToTypeRef("L" + cr.getName() + ";"));
        DependencyAnalysis.scanSuperTypes(cr, ret);
        DependencyAnalysis.scanFields(cr, ret);
        DependencyAnalysis.scanMethods(cr, ret);
        return ret;
    }

    private static void scanSuperTypes(ClassReader cr, DAClassInfo ret) throws InvalidClassFileException {
        for (String interfaceNameStr : cr.getInterfaceNames()) {
            TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef("L" + interfaceNameStr + ";");
            ret.addDependantClass(typeRef);
        }
        String superNameStr = "L" + cr.getSuperName() + ";";
        TypeReference superType = DependencyAnalysis.typeStringToTypeRef(superNameStr);
        ret.addDependantClass(superType);
    }

    private static void scanFields(ClassReader cr, DAClassInfo ret) throws InvalidClassFileException {
        for (int i = 0; i < cr.getFieldCount(); ++i) {
            String fieldTypeStr = cr.getFieldType(i);
            TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(fieldTypeStr);
            ret.addDependantClass(typeRef);
        }
    }

    private static void scanMethods(ClassReader cr, final DAClassInfo ret) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        IInstruction.Visitor v = new IInstruction.Visitor(){

            public void visitConstant(ConstantInstruction instruction) {
                if ("Ljava/lang/Class;".equals(instruction.getType())) {
                    ConstantInstruction.ClassToken classToken = (ConstantInstruction.ClassToken)instruction.getValue();
                    TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(classToken.getTypeName());
                    ret.addDependantClass(typeRef);
                }
            }

            public void visitLocalLoad(ILoadInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitLocalStore(IStoreInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitArrayStore(IArrayStoreInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitUnaryOp(IUnaryOpInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitShift(IShiftInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitConversion(IConversionInstruction instruction) {
                TypeReference fromTypeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getFromType());
                ret.addDependantClass(fromTypeRef);
                TypeReference toTypeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getToType());
                ret.addDependantClass(toTypeRef);
            }

            public void visitComparison(IComparisonInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                TypeReference typeRef = DependencyAnalysis.typeStringToTypeRef(instruction.getType());
                ret.addDependantClass(typeRef);
            }

            public void visitGet(IGetInstruction instruction) {
                ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(instruction.getFieldType()));
            }

            public void visitPut(IPutInstruction instruction) {
                ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(instruction.getFieldType()));
            }

            public void visitInvoke(IInvokeInstruction instruction) {
                ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(instruction.getClassType()));
            }

            public void visitNew(NewInstruction instruction) {
                ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(instruction.getType()));
            }

            public void visitCheckCast(CheckCastInstruction instruction) {
                String[] types;
                for (String tName : types = instruction.getTypes()) {
                    ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(tName));
                }
            }

            public void visitInstanceof(InstanceofInstruction instruction) {
                ret.addDependantClass(DependencyAnalysis.typeStringToTypeRef(instruction.getType()));
            }
        };
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        for (int i = 0; i < cr.getMethodCount(); ++i) {
            cr.initMethodAttributeIterator(i, iter);
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    DependencyAnalysis.scanMethod(ret, iter, v);
                }
                iter.advance();
            }
        }
    }

    private static void scanMethod(DAClassInfo ret, ClassReader.AttrIterator iter, IInstruction.Visitor v) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        CodeReader code = new CodeReader(iter);
        CTDecoder d = new CTDecoder(code);
        d.decode();
        for (IInstruction instruction : d.getInstructions()) {
            instruction.visit(v);
        }
    }

    private static TypeReference typeStringToTypeRef(String typeStr) {
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)generalClassLoaderRef, (String)typeStr);
        while (typeRef.isArrayType()) {
            typeRef = typeRef.getArrayElementType();
        }
        String name = typeRef.getName().toString();
        assert (name.length() == 1 || name.endsWith(";") && name.startsWith("L")) : "poor type name: " + typeStr;
        return typeRef;
    }

    public static class DAClassInfo {
        private TypeReference type;
        private Set<TypeReference> referencedTypes;

        public DAClassInfo(TypeReference type) {
            this.type = type;
            this.referencedTypes = new HashSet<TypeReference>();
        }

        public void addDependantClass(TypeReference depClass) {
            this.referencedTypes.add(depClass);
        }

        public TypeReference getType() {
            return this.type;
        }

        public Set<TypeReference> getReferencedTypes() {
            return Collections.unmodifiableSet(this.referencedTypes);
        }
    }
}

