/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.dependencyAnalysis;

import com.ibm.wala.andromeda.util.dependencyAnalysis.DAGraph;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import java.util.Map;

public class PackageDependencyGraph {
    private final Graph<DAGraph.GeneralNubmeredNode<Module>> moduleGraph;

    public PackageDependencyGraph(DAGraph typeReferenceGraph, Map<ModuleEntry, Module> entryToContainingModule) {
        this.moduleGraph = typeReferenceGraph.createAbstractGraph(entryToContainingModule);
    }

    public void writeToDot(String fileName) throws WalaException {
        this.writeToDot(fileName, (Predicate<Module>)IndiscriminateFilter.singleton());
    }

    public void writeToDot(String fileName, final Predicate<Module> filter) throws WalaException {
        NodeDecorator decorator = new NodeDecorator(){

            public String getLabel(Object o) throws WalaException {
                DAGraph.GeneralNubmeredNode n = (DAGraph.GeneralNubmeredNode)((Object)o);
                return ((Module)n.getData()).toString().replace("\\", "\\\\");
            }
        };
        Predicate<DAGraph.GeneralNubmeredNode<Module>> nodeFilter = new Predicate<DAGraph.GeneralNubmeredNode<Module>>(){

            public boolean test(DAGraph.GeneralNubmeredNode<Module> o) {
                return filter.test((Object)o.getData());
            }
        };
        Graph filteredGraph = GraphSlicer.prune(this.moduleGraph, (Predicate)nodeFilter);
        DotUtil.writeDotFile((Graph)filteredGraph, (NodeDecorator)decorator, (String)"Package Dependency Analysis", (String)fileName);
    }
}

