/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.io;

import com.ibm.wala.andromeda.util.Activator;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.ide.util.EclipseFileProvider;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class TaintFileProvider {
    public static boolean DEBUG = false;
    public static final String DAT_PREFIX = "dat/";
    public static Map<String, File> fileMap = new HashMap<String, File>();

    public static File getFile(String fileName) throws IOException {
        File f = null;
        Activator pluginActivator = null;
        if (!System.getProperty("com.ibm.wala.andromeda.util.usingEclipse").toLowerCase().equals("false") && (pluginActivator = Activator.getDefault()) != null) {
            EclipseFileProvider efp = new EclipseFileProvider();
            f = efp.getFileFromPlugin((Plugin)pluginActivator, DAT_PREFIX + fileName);
        } else {
            if (fileMap.containsKey(fileName)) {
                return fileMap.get(fileName);
            }
            DebugOutput.println(DEBUG, "Trying to load:" + fileName);
            InputStream in = FileProvider.class.getResourceAsStream("/" + fileName);
            if (in == null) {
                DebugOutput.println(DEBUG, "Could not find " + fileName);
                return null;
            }
            f = File.createTempFile("TaintFileProvider", "Temp");
            DebugOutput.println(DEBUG, fileName + " -> " + f.getAbsolutePath());
            f.deleteOnExit();
            FileOutputStream out = new FileOutputStream(f);
            int b = 0;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            out.close();
            in.close();
            fileMap.put(fileName, f);
        }
        return f;
    }

    public static File getBundleDir(String bundleID, Class<?> bundleClass) {
        try {
            File bundleDir;
            Class<?> javaUtilCls = bundleClass.getClassLoader().loadClass("com.ibm.rational.appscan.impl.common.JavaUtil");
            Class[] parameterTypes = new Class[]{String.class, Class.class};
            Method computeBundleDirectoryMethod = javaUtilCls.getMethod("computeBundleDirectory", parameterTypes);
            Object ret = computeBundleDirectoryMethod.invoke(null, bundleID, bundleClass);
            if (ret instanceof File && (bundleDir = (File)ret).isDirectory()) {
                return bundleDir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

