/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.logging;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DebugOutput {
    public static final boolean DEFAULT_DEBUG = false;
    public static boolean DEBUG = false;
    private static DebugLevel debuggingLevel = DebugLevel.STANDARD;
    private static String OZ_INFO_OPEN_TAG = "<ozinfo>";
    private static String OZ_INFO_CLOSE_TAG = "</ozinfo>";

    public static void printOunceInfo(String s) {
        System.out.println(OZ_INFO_OPEN_TAG + s + OZ_INFO_CLOSE_TAG);
    }

    public static void println(boolean doPrint, String s) {
        if (doPrint) {
            System.err.println(s);
        }
    }

    public static void println(boolean doPrint, Object s) {
        if (doPrint) {
            System.err.println(s.toString());
        }
    }

    public static void println(String s) {
        if (DEBUG) {
            System.err.println(s);
        }
    }

    public static void println(Object s) {
        if (DEBUG) {
            System.err.println(s.toString());
        }
    }

    public static void println(DebugLevel level, String s) {
        if (debuggingLevel.subsumes(level)) {
            System.err.println(s);
        }
    }

    public static void println(DebugLevel level, Object o) {
        if (debuggingLevel.subsumes(level)) {
            System.err.println(o.toString());
        }
    }

    public static void printNewFeature(String s) {
        DebugOutput.println(DebugLevel.NEW_FEATURE, s);
    }

    public static void setDebugging(boolean debug) {
        DEBUG = debug;
    }

    public static void setDebuggingLevel(DebugLevel l) {
        debuggingLevel = l;
    }

    public static String stackTraceToString(FileNotFoundException fnfe) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        fnfe.printStackTrace(out);
        return stringWriter.toString();
    }

    public static class DebugLevel {
        public static final DebugLevel NEW_FEATURE = new DebugLevel(0);
        public static final DebugLevel STANDARD = new DebugLevel(1);
        public static final DebugLevel VERBOSE = new DebugLevel(2);
        private final int level;

        private DebugLevel(int level) {
            this.level = level;
        }

        public boolean subsumes(DebugLevel l) {
            return this.level >= l.level;
        }
    }
}

