/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import java.io.Serializable;
import java.util.Arrays;

public class SimpleIntVector
implements IntVector,
Serializable {
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private static final float GROWTH_FACTOR = 1.5f;
    private static final int INITIAL_SIZE = 1;
    int maxIndex = -1;
    int[] store;
    final int defaultValue;

    public SimpleIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
        this.store = new int[this.getInitialSize()];
        this.store[0] = defaultValue;
    }

    public SimpleIntVector(int defaultValue, int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Illegal initialSize: " + initialSize);
        }
        this.defaultValue = defaultValue;
        this.store = new int[initialSize];
        this.store[0] = defaultValue;
    }

    int getInitialSize() {
        return 1;
    }

    float getGrowthFactor() {
        return 1.5f;
    }

    @Override
    public int get(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        if (x < this.store.length) {
            return this.store[x];
        }
        return this.defaultValue;
    }

    @Override
    public void set(int x, int value) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        if (x > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + x);
        }
        this.maxIndex = Math.max(this.maxIndex, x);
        if (value == this.defaultValue) {
            if (x >= this.store.length) {
                return;
            }
            this.store[x] = value;
        } else {
            this.ensureCapacity(x);
            this.store[x] = value;
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.store.length) {
            int[] old = this.store;
            this.store = new int[1 + (int)(this.getGrowthFactor() * (float)capacity)];
            Arrays.fill(this.store, this.defaultValue);
            System.arraycopy(old, 0, this.store, 0, old.length);
        }
    }

    public void performVerboseAction() {
        System.err.println("size:       " + this.store.length);
        System.err.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int count1 = 0;
        for (int i = 0; i < this.store.length; ++i) {
            if (this.store[i] == -1) continue;
            ++count1;
        }
        int count = count1;
        return (double)count / (double)this.store.length;
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

