/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.hcl.clazz.info.FieldTracker;
import com.ibm.appscan.assessment.model.Finding;
import java.util.ArrayList;
import java.util.HashSet;

public class ClassFieldTracker {
    private String m_class_name;
    private ArrayList<FieldTracker> m_field_trackers;
    private HashSet<String> m_fields;

    public ClassFieldTracker(String name) {
        this.m_class_name = name;
    }

    public void addFieldTracker(FieldTracker ft) {
        this.getFieldTrackers().add(ft);
    }

    public void addClassField(String field) {
        this.getClassFields().add(field);
    }

    public HashSet<String> getClassFields() {
        if (this.m_fields == null) {
            this.m_fields = new HashSet();
        }
        return this.m_fields;
    }

    public ArrayList<FieldTracker> getFieldTrackers() {
        if (this.m_field_trackers == null) {
            this.m_field_trackers = new ArrayList();
        }
        return this.m_field_trackers;
    }

    public String getClassName() {
        return this.m_class_name;
    }

    public boolean isValidDataFlow(Finding f) {
        for (FieldTracker ft : this.getFieldTrackers()) {
            if (ft.allowsForDataFlow(f)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Class:");
        ret.append(this.m_class_name);
        ret.append(System.lineSeparator());
        for (FieldTracker ft : this.getFieldTrackers()) {
            ret.append(ft.toString());
        }
        return ret.toString();
    }
}

