/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.clazz.info.visitors.ClassVisitorImpl;
import java.util.HashSet;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class ClassReferences {
    private HashSet<String> m_classes_called = new HashSet();

    public HashSet<String> getClassesCalled() {
        return this.m_classes_called;
    }

    public void addClassCalled(String clazz) {
        block31: {
            ClassVisitorImpl.printDebug("CLASS_REF_CHECKING", "", clazz, 5);
            if (clazz != null && clazz.length() > 1 && !clazz.contains(" ")) {
                if (clazz.indexOf("<") != -1) {
                    StringBuilder sig = new StringBuilder();
                    block17: for (char c : clazz.toCharArray()) {
                        switch (c) {
                            case '(': 
                            case ')': 
                            case '*': 
                            case '+': {
                                continue block17;
                            }
                            case ':': {
                                sig.delete(0, sig.length());
                                continue block17;
                            }
                            case ';': 
                            case '<': 
                            case '>': {
                                if (sig.length() <= 0) continue block17;
                                sig.append(";");
                                this.addClassCalled(sig.toString());
                                sig.delete(0, sig.length());
                                continue block17;
                            }
                            case '.': {
                                break block31;
                            }
                            case '-': 
                            case '[': {
                                if (sig.length() == 0) continue block17;
                            }
                            default: {
                                sig.append(c);
                            }
                        }
                    }
                } else {
                    Type t = null;
                    try {
                        t = Type.getType((String)clazz);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (t != null) {
                        if (t.getSort() == 10) {
                            ClassVisitorImpl.printDebug("CLASS_REF_OBJECT", "", t, 5);
                            this.addClassCalled(t);
                        } else if (t.getSort() == 9) {
                            ClassVisitorImpl.printDebug("CLASS_REF_ARRAY_INIT", "", t.getInternalName(), 5);
                            if (this.isValidType(t)) {
                                this.addClassCalled(t);
                                try {
                                    ClassVisitorImpl.printDebug("CLASS_REF_ARRAY_ELEM_TYPE", "", t.getElementType(), 5);
                                    this.addClassCalled(t.getElementType());
                                }
                                catch (Exception exception) {}
                            }
                        } else if (t.getSort() == 11) {
                            ClassVisitorImpl.printDebug("CLASS_REF_METHOD", "", t, 5);
                            this.addClassCalled(t);
                            try {
                                try {
                                    for (Type arg : t.getArgumentTypes()) {
                                        try {
                                            ClassVisitorImpl.printDebug("CLASS_REF_METHOD_ARG", "", arg, 5);
                                            this.addClassCalled(arg);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ClassVisitorImpl.printDebug("CLASS_REF_METHOD", "", t.getReturnType(), 5);
                                this.addClassCalled(t.getReturnType());
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        String name = ClassInfo.getCleanClassName(clazz);
                        if (this.isValidClassName(name)) {
                            this.m_classes_called.add(name);
                            ClassVisitorImpl.printDebug("CLASS_REF_ADDING_NON_TYPE", "", name, 5);
                        }
                    }
                }
            }
        }
    }

    public void addClassCalled(Handle h) {
        if (h != null) {
            ClassVisitorImpl.printDebug("CLASS_REF_HANDLE_DESC", "", h.getDesc(), 5);
            this.addClassCalled(h.getDesc());
            ClassVisitorImpl.printDebug("CLASS_REF_HANDLE_OWBER", "", h.getOwner(), 5);
            this.addClassCalled(h.getOwner());
        }
    }

    public void addClassCalled(String[] names) {
        if (names != null) {
            for (String s : names) {
                this.addClassCalled(s);
            }
        }
    }

    public void addClassCalled(Type t) {
        if (t != null) {
            ClassVisitorImpl.printDebug("CLASS_REF_PRE_ADD", "", t, 5);
            if (this.isValidClassName(t.toString())) {
                String name = ClassInfo.getCleanClassName(t.getInternalName());
                this.m_classes_called.add(name);
                ClassVisitorImpl.printDebug("CLASS_REF_ADDING", "", name, 5);
            }
        }
    }

    private boolean isValidType(Type t) {
        StringBuilder str = new StringBuilder();
        for (char c : t.getInternalName().toCharArray()) {
            if (!Character.isLetter(c)) continue;
            str.append(c);
        }
        return !str.toString().equals("TT") && !str.toString().equals("TE") && !str.toString().equals("TL");
    }

    private boolean isValidClassName(String name) {
        return this.isValidType(Type.getMethodType((String)name)) && !name.startsWith("(") && name.length() > 1 && !name.startsWith("[") && !name.startsWith("T");
    }
}

