/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.HashSet;
import org.objectweb.asm.Type;

public class MethodInfo {
    private Method m_method;
    private HashSet<String> m_class_fields_present;

    public MethodInfo(String class_name, String name, String desc) throws BadMarkupException, VDBException {
        this(class_name, 1, name, desc, null, new String[0]);
    }

    public MethodInfo(String class_name, int access, String name, String desc, String signature, String[] exceptions) throws BadMarkupException, VDBException {
        this.m_method = MethodProvider.getMethod((String)MethodInfo.calculateFullSignature(class_name, name, desc), (Language.LANGUAGE)Language.LANGUAGE.JAVA);
        if ((2 & access) == 2) {
            this.getMethod().addProperty("Attribute.Modifier.Private");
        } else if ((4 & access) != 4 && (1 & access) != 1) {
            this.getMethod().addProperty("Attribute.Modifier.PackageProtected");
        }
        if ((8 & access) == 8) {
            this.getMethod().addProperty("Attribute.Modifier.Static");
        }
        if ((0x200 & access) == 512) {
            this.getMethod().addProperty("Attribute.Modifier.Interface");
        }
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getFullSignature() {
        return this.getMethod().getSignature();
    }

    private static String calculateFullSignature(String class_name, String name, String desc) {
        StringBuilder ret = new StringBuilder();
        ret.append(class_name);
        ret.append(".");
        ret.append(name);
        ret.append("(");
        int args = 0;
        for (Type t : Type.getArgumentTypes((String)desc)) {
            ret.append(MethodInfo.getTypeString(t));
            ret.append(";");
            ++args;
        }
        if (args > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        ret.append(")");
        ret.append(":");
        ret.append(MethodInfo.getTypeString(Type.getReturnType((String)desc)));
        return ret.toString();
    }

    private static String getTypeString(Type t) {
        switch (t.getSort()) {
            case 9: {
                try {
                    return MethodInfo.getTypeString(t.getElementType()) + String.format("%0" + t.getDimensions() + "d", 0).replace("0", "[]");
                }
                catch (Exception e) {
                    return "";
                }
            }
            case 10: {
                return t.getClassName().toString();
            }
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 5: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 4: {
                return "short";
            }
        }
        return "HHH";
    }

    public HashSet<String> getClassFieldsPresent() {
        if (this.m_class_fields_present == null) {
            this.m_class_fields_present = new HashSet();
        }
        return this.m_class_fields_present;
    }

    public String getMethodName() {
        return this.getMethod().getSimpleMethodName();
    }
}

