/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.weblogic;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.weblogic.Messages;
import com.ibm.appscan.internal.discovery.weblogic.compilers.WeblogicJSPCompilerDefinition;
import com.ibm.appscan.internal.discovery.weblogic.compilers.WeblogicJSPCompilerType;
import java.io.File;
import java.util.Set;

public class WeblogicStrategy
extends Strategy {
    protected File m_wlshome;
    protected IStrategyFactoryRegistry m_registry;
    protected WeblogicJSPCompilerDefinition m_jspCompiler = null;

    public WeblogicStrategy() {
    }

    WeblogicStrategy(File serverHome, IStrategyFactoryRegistry registry, WeblogicJSPCompilerDefinition jspCompiler) {
        this.m_wlshome = serverHome;
        this.m_registry = registry;
        this.m_jspCompiler = jspCompiler;
    }

    protected File getServerHome() {
        return this.m_wlshome;
    }

    public void init(File directory, IStrategyFactoryRegistry registry) {
        this.m_wlshome = directory;
        this.m_registry = registry;
        File serverHome = this.getServerHome();
        if (serverHome != null) {
            this.m_jspCompiler = (WeblogicJSPCompilerDefinition)new WeblogicJSPCompilerType().autoCreate(serverHome.getPath());
        }
    }

    public String getName() {
        return this.m_wlshome.getName();
    }

    public String getType() {
        return Messages.getMessage("weblogic", new Object[0]);
    }

    public String getPath() {
        return this.m_wlshome.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean handlesIncludesExcludes() {
        return true;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        File[] auto_deploy = new File(this.m_wlshome, "user_projects\\domains\\base_domain\\autodeploy").listFiles();
        if (auto_deploy != null) {
            for (File deploy : auto_deploy) {
                ScanTargetStrategy strategy = this.m_registry.getStrategy(deploy);
                if (strategy == null) continue;
                CustomTargetInfo info = new CustomTargetInfo();
                info.getIncludes().addAll(proxy.getIncludes());
                info.getExcludes().addAll(proxy.getExcludes());
                proxy.newScanTarget(strategy, info);
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

