/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.gradle;

import com.hcl.appscan.discovery.gradle.Messages;
import com.hcl.appscan.internal.discovery.gradle.GradleRunner;
import com.hcl.appscan.internal.discovery.gradle.GradleStrategy;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class GradleStrategyFactory
implements IStrategyFactory {
    private static boolean m_reportedWarning = false;
    private static final String BUILD_GRADLE = "build.gradle";

    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        File buildGradle = new File(fileOrDirectory, BUILD_GRADLE);
        if (!DiscoveryCore.isTopLevelTarget((File)fileOrDirectory) || SystemUtil.isCommonEngine() || SystemUtil.isCloudIRGen()) {
            return null;
        }
        if (buildGradle.exists() || fileOrDirectory.isFile() && fileOrDirectory.getName().equalsIgnoreCase(BUILD_GRADLE)) {
            DiscoveryCore.getThirdPartyLibTarget().inject(buildGradle.getAbsolutePath());
            return this.isGradleInstalled(fileOrDirectory) ? new GradleStrategy(fileOrDirectory, registry) : null;
        }
        return null;
    }

    public boolean isBuildOutput() {
        return false;
    }

    public void loadUniqueTarget(IScan scan) {
    }

    private boolean isGradleInstalled(File fileOrDirectory) {
        if (fileOrDirectory.isFile()) {
            fileOrDirectory = fileOrDirectory.getParentFile();
        }
        int rc = 1;
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-v");
            rc = new GradleRunner(fileOrDirectory, false).run(args);
        }
        catch (IOException e) {
            CommonCore.getLogManager().log(new Message(1, Messages.getMessage("gradle.run.error", e.getMessage())));
        }
        if (rc != 0 && !m_reportedWarning) {
            Message message = new Message(1, Messages.getMessage("no.gradle.found", new Object[0]));
            CommonCore.getLogManager().log(message);
            CommonCore.getIOConsole().println(message);
            m_reportedWarning = true;
        }
        return rc == 0;
    }
}

