/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.logging.LogMerger;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.config.Messages;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.internal.config.ReadXMLFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;

public class LogMergerScanManifest
extends LogMerger {
    Map<String, Set<IScanFile>> m_language_file_map;
    HashSet<String> m_namespaces_set;

    public LogMergerScanManifest(File destination, IScan scan) throws IOException {
        super(destination, ".targetinfo", scan);
    }

    protected String getNewFileName(String supplied_name) {
        return "scan.manifest";
    }

    protected Map<String, Set<IScanFile>> getLanguageFileMap() {
        if (this.m_language_file_map == null) {
            this.m_language_file_map = new HashMap<String, Set<IScanFile>>();
        }
        return this.m_language_file_map;
    }

    protected HashSet<String> getNamespaces() {
        if (this.m_namespaces_set == null) {
            this.m_namespaces_set = new HashSet();
        }
        return this.m_namespaces_set;
    }

    public boolean hasEntriesToMerge() throws IOException {
        return true;
    }

    protected void visitAndMergeFile() throws IOException {
        this.getMergedFile().getParentFile().mkdirs();
        try {
            Path path = this.getMergedFile().getParentFile().getParentFile().toPath();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().equals(LogMergerScanManifest.this.getFileName())) {
                        ReadXMLFile handler = new ReadXMLFile(file.toFile());
                        try {
                            handler.read();
                        }
                        catch (XMLStreamException e) {
                            LogMergerScanManifest.this.getLogManager().log((Exception)e);
                        }
                        handler.getTargetScans(LogMergerScanManifest.this.getLanguageFileMap());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            this.saveFile();
        }
        catch (IOException exp) {
            this.getLogManager().log((Exception)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFile() {
        BufferedWriter bw = null;
        this.populateNamespaces();
        try {
            bw = new BufferedWriter(new FileWriter(this.getMergedFile(), false));
            bw.write(Messages.getMessage("scan.manifest.generate", new Object[0]));
            bw.newLine();
            bw.write(Messages.getMessage("scan.summary", new Object[0]));
            bw.newLine();
            bw.write("\t" + Messages.getMessage("scan.languages.total", this.getLanguageCountWithScanFiles()));
            bw.newLine();
            ArrayList<String> languages = new ArrayList<String>(this.m_language_file_map.keySet());
            Collections.sort(languages, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals("ws") || o1.equals("thirdpartylib") || o1.equals("Open Source")) {
                        return -1;
                    }
                    if (o2.equals("ws") || o2.equals("thirdpartylib") || o2.equals("Open Source")) {
                        return 1;
                    }
                    return o1.compareToIgnoreCase(o2);
                }
            });
            if (this.m_namespaces_set.size() > 0) {
                bw.write("\t" + Messages.getMessage("scan.packages.namespaces", new Object[0]));
                bw.newLine();
                for (String pckg : this.m_namespaces_set) {
                    bw.write("\t\t" + pckg);
                    bw.newLine();
                }
            }
            bw.write(Messages.getMessage("scan.details", new Object[0]));
            bw.newLine();
            for (String lang : languages) {
                if (this.m_language_file_map.get(lang).size() <= 0) continue;
                bw.write("\t" + Messages.getMessage("scan.language", lang));
                bw.newLine();
                bw.write("\t" + Messages.getMessage("scan.analyze", new Object[0]));
                bw.newLine();
                TreeSet<String> sortedScanFilePaths = new TreeSet<String>();
                for (IScanFile file : this.m_language_file_map.get(lang)) {
                    sortedScanFilePaths.add(this.getPathFromScanFile(file));
                }
                for (String scanFilePath : sortedScanFilePaths) {
                    bw.write("\t\t");
                    bw.write(scanFilePath);
                    bw.newLine();
                }
                bw.newLine();
            }
            bw.flush();
            IOUtil.close((Closeable)bw);
        }
        catch (IOException e) {
            this.getLogManager().log((Exception)e);
        }
        finally {
            IOUtil.close(bw);
        }
    }

    protected int getLanguageCountWithScanFiles() {
        int count = 0;
        for (String lang : this.m_language_file_map.keySet()) {
            if (this.m_language_file_map.get(lang).size() <= 0) continue;
            ++count;
        }
        return count;
    }

    protected String getPathFromScanFile(IScanFile scan_file) throws IOException {
        String path = scan_file.getSourcePath();
        File temp = null;
        if (System.getenv("TEMP") != null) {
            temp = new File(System.getenv("TEMP"));
        }
        if (temp == null && System.getenv("TMP") != null) {
            temp = new File(System.getenv("TMP"));
        }
        if (path == null) {
            if (scan_file.getFile().isAbsolute() && temp != null && !scan_file.getFile().getAbsolutePath().startsWith(temp.getAbsolutePath()) && !scan_file.getFile().getAbsolutePath().startsWith(this.getMergedFile().getParentFile().getParentFile().getAbsolutePath()) && scan_file.getFile().exists()) {
                return scan_file.getFile().getAbsolutePath().replaceAll("\\\\", "/");
            }
            path = scan_file.getFile().getName();
        }
        File path_test = new File(path);
        if (temp != null && path_test.getCanonicalPath().startsWith(temp.getCanonicalPath())) {
            path = path_test.getCanonicalPath().substring(temp.getCanonicalPath().length() + 1);
        }
        path = path.replaceAll("\\\\", "/");
        if (DiscoveryCore.getParentForScanFile((File)scan_file.getFile()) != null && DiscoveryCore.getParentForScanFile((File)scan_file.getFile()).length() > 0) {
            path = DiscoveryCore.getParentForScanFile((File)scan_file.getFile()) + "/" + path;
        } else if (scan_file.getSourcePath() != null && DiscoveryCore.getParentForScanFile((File)new File(scan_file.getSourcePath())) != null && DiscoveryCore.getParentForScanFile((File)new File(scan_file.getSourcePath())).length() > 0) {
            path = DiscoveryCore.getParentForScanFile((File)new File(scan_file.getSourcePath())) + "/" + path;
        }
        return path;
    }

    protected void populateNamespaces() {
        this.getNamespaces();
        this.getScan().accept(new ScanModelVisitor(){

            protected void visit(IScanTarget target) {
                LogMergerScanManifest.this.m_namespaces_set.addAll(target.getNameSpaces());
            }
        });
    }
}

