/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ProgressTracker;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.config.Messages;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ScanModelVisitorWithProgress
extends ScanModelVisitor {
    ProgressTracker m_tracker = new ProgressTracker(1);
    Map<IScanTarget, ProgressTracker> m_childTrackers = new HashMap<IScanTarget, ProgressTracker>();
    private IProgress m_progress;
    private int m_numFiles;
    private boolean m_onlyOpenSource;
    private boolean m_isValid;

    public ScanModelVisitorWithProgress(IProgress progress, boolean isDryRun, IScan scan) {
        super(isDryRun);
        this.m_progress = progress == null ? new NullProgress() : progress;
        this.m_numFiles = 0;
        this.m_onlyOpenSource = true;
        this.m_isValid = true;
        this.trackChildProgress(this.m_tracker, scan.getScanTargets());
    }

    public int getNumFiles() {
        return this.m_numFiles;
    }

    public boolean onlyOpenSource() {
        return this.m_onlyOpenSource;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public int getPercentComplete() {
        return this.m_tracker.getPercentComplete();
    }

    public void visit(IScanTarget target) {
        if (!target.isValid()) {
            this.m_progress.setStatus(new Message(1, Messages.getMessage("validating.target", new File(target.getPath()).getName())));
            ProgressTracker thisTracker = this.m_childTrackers.get(target);
            if (thisTracker == null) {
                thisTracker = new ProgressTracker(1);
                this.m_childTrackers.put(target, thisTracker);
            }
            target.findScanFiles(this.m_progress);
            this.m_isValid &= target.isValid();
            if (target.getChildren() == null || target.getChildren().isEmpty()) {
                thisTracker.setComplete();
            } else {
                this.trackChildProgress(thisTracker, target.getChildren());
            }
            this.reportProgress();
        }
        int numScanFiles = this.getIncludedScanFiles(target);
        if (!"thirdpartylib".equals(target.getType()) && numScanFiles != 0) {
            this.m_onlyOpenSource = false;
        }
        this.m_numFiles += numScanFiles;
    }

    private void trackChildProgress(ProgressTracker progressTracker, Collection<IScanTarget> scanTargets) {
        for (IScanTarget child : scanTargets) {
            if (child.getName() == "WhiteSource" || child.getName() == "ThirdPartyLib") continue;
            ProgressTracker childProgressTracker = new ProgressTracker(1);
            progressTracker.addChildTracker(childProgressTracker);
            this.m_childTrackers.put(child, childProgressTracker);
        }
    }

    private int getIncludedScanFiles(IScanTarget target) {
        int count = 0;
        for (IScanFile scanFile : target.getScanFiles()) {
            if (scanFile.isExcluded()) continue;
            ++count;
        }
        return count;
    }

    private void reportProgress() {
        if (SystemUtil.shouldShowProgress()) {
            this.m_progress.setStatus(new Message(1, Messages.getMessage("report.progress", this.m_tracker.getPercentComplete())));
        }
    }
}

