/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.model;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.IStagingProvider;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.xml.TargetInfoReader;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class TargetInfoStrategy
extends Strategy {
    private File m_directory;
    private IStrategyFactoryRegistry m_registry;
    private TargetInfoReader m_reader;
    private Strategy m_innerStrategy = null;
    private boolean m_scanFilesReturned = false;
    private String m_errorMessage = null;

    public TargetInfoStrategy() {
    }

    TargetInfoStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    @Override
    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_directory = file.getParentFile();
        this.m_registry = registry;
        this.m_reader = new TargetInfoReader(file);
        String strategyName = null;
        try {
            this.m_reader.read();
            strategyName = this.m_reader.getStrategy();
            Class<?> strategyClass = Class.forName(strategyName);
            this.m_innerStrategy = (Strategy)((Object)strategyClass.newInstance());
            this.m_innerStrategy.init(new File(this.m_reader.getPath()), registry);
        }
        catch (ClassNotFoundException strategyClass) {
        }
        catch (Exception e) {
            this.m_errorMessage = Messages.getMessage("err.strategy", strategyName);
        }
    }

    public void setStagingProvider(IStagingProvider provider) {
        super.setStagingProvider(provider);
        if (this.m_innerStrategy != null) {
            this.m_innerStrategy.setStagingProvider(provider);
        }
    }

    public void setParent(ScanTargetStrategy parent) {
        super.setParent(parent);
        if (this.m_innerStrategy != null) {
            this.m_innerStrategy.setParent(((TargetInfoStrategy)parent).m_innerStrategy);
        }
    }

    public ScanTargetStrategy getParent() {
        return this.m_innerStrategy != null ? this.m_innerStrategy.getParent() : super.getParent();
    }

    public String getName() {
        return this.m_reader.getName();
    }

    public String getType() {
        return this.m_reader.getType();
    }

    public String getPath() {
        return this.m_reader.getPath();
    }

    public String getStrategyClass() {
        return this.m_reader.getStrategy();
    }

    public String getLanguageType() {
        return this.m_reader.getLanguageType();
    }

    public boolean handlesIncludesExcludes() {
        return this.m_innerStrategy != null ? this.m_innerStrategy.handlesIncludesExcludes() : super.handlesIncludesExcludes();
    }

    public StringPattern getAdjustedPattern(StringPattern pattern) {
        return this.m_innerStrategy != null ? this.m_innerStrategy.getAdjustedPattern(pattern) : super.getAdjustedPattern(pattern);
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (this.m_errorMessage != null) {
            proxy.getErrorManager().reportError(this.m_errorMessage);
            return;
        }
        for (String path : this.m_reader.getTargetInfos()) {
            File file = new File(this.m_directory, path);
            proxy.newScanTarget((ScanTargetStrategy)new TargetInfoStrategy(file, this.m_registry));
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.m_errorMessage != null) {
            proxy.getErrorManager().reportError(this.m_errorMessage);
            return null;
        }
        if (this.m_reader.isTransformed() && !this.m_scanFilesReturned) {
            this.m_scanFilesReturned = true;
            for (Map.Entry entry : this.m_reader.getBuildInfos().entrySet()) {
                proxy.getBuildInfo().setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return this.m_reader.getScanFiles();
        }
        return this.m_innerStrategy == null ? null : this.m_innerStrategy.getScanFiles(proxy, progress);
    }
}

