/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.tsql;

import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.discovery.tsql.ITSQLConstants;
import com.ibm.appscan.internal.discovery.tsql.TSQLStrategy;
import java.io.File;
import java.util.Set;

public class TSQLCollector
extends BaseCustomCollector
implements ITSQLConstants {
    public TSQLCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "TSQLCollector";
    }

    protected String getFileExtensionSetName() {
        return "tsql";
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        String root = this.getCrawlRoot().getAbsolutePath();
        if (parentStrategy != null && parentStrategy instanceof FileCollectorStrategy) {
            root = ((FileCollectorStrategy)parentStrategy).getStagingDirectory().getAbsolutePath();
        }
        return new TSQLStrategy(root, this.getScanFiles());
    }
}

