/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetCollector;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import com.ibm.appscan.internal.discovery.dir.DirectoryStrategy;
import com.ibm.appscan.internal.discovery.model.TargetInfoStrategy;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class DiscoveryCore {
    private static StrategyFactoryRegistry registry = new StrategyFactoryRegistry();
    private static IScanTarget thirdPartyLibTarget = null;
    private static HashMap<String, String> s_parent_map = new HashMap();
    private static Set<String> s_topLevelTargets = new HashSet<String>();

    private DiscoveryCore() {
    }

    public static IScanTarget getThirdPartyLibTarget() {
        return thirdPartyLibTarget;
    }

    public static void addScanFileParent(File scan_file, String parent) {
        s_parent_map.put(scan_file.getPath(), parent);
    }

    public static String getParentForScanFile(File scan_file) {
        if (s_parent_map.containsKey(scan_file.getPath())) {
            return s_parent_map.get(scan_file.getPath());
        }
        return s_parent_map.get(scan_file.getAbsolutePath());
    }

    public static ScanTargetStrategy getStrategyForDirectory(File directory, boolean outputsOnly) {
        ScanTargetStrategy strategy;
        if (!SystemUtil.isOpenSourceOnly() && (strategy = registry.getStrategy(directory, outputsOnly ? StrategyFactoryRegistry.StrategyType.OUTPUTS : StrategyFactoryRegistry.StrategyType.ALL)) != null) {
            return strategy;
        }
        DirectoryStrategy dirStrategy = new DirectoryStrategy(directory, thirdPartyLibTarget, registry);
        dirStrategy.setOutputsOnly(outputsOnly);
        return dirStrategy;
    }

    public static int findScanTargets(IScan scan, File fileOrDirectory, boolean outputsOnly, IProgress progress) {
        s_topLevelTargets.add(fileOrDirectory.getAbsolutePath());
        int count = 0;
        registry.loadUniqueTargets(scan);
        for (IScanTarget target : scan.getScanTargets()) {
            if (!"ThirdPartyLib".equals(target.getName())) continue;
            thirdPartyLibTarget = target;
            break;
        }
        ScanTargetStrategy strategy = null;
        if (fileOrDirectory.isDirectory()) {
            strategy = DiscoveryCore.getStrategyForDirectory(fileOrDirectory, outputsOnly);
        } else if (!SystemUtil.isOpenSourceOnly()) {
            registry.useAlternativeStrategies(true);
            strategy = registry.getStrategy(fileOrDirectory, StrategyFactoryRegistry.StrategyType.ALL);
            registry.useAlternativeStrategies(false);
        } else {
            if (thirdPartyLibTarget != null) {
                thirdPartyLibTarget.inject(fileOrDirectory.getAbsolutePath());
            }
            return 0;
        }
        if (strategy != null) {
            IScanTarget target;
            target = scan.newScanTarget(strategy);
            if (strategy instanceof DirectoryStrategy) {
                target.setIsDirectoryTarget(true);
            } else if (strategy instanceof TargetInfoStrategy) {
                target.setIsDirectoryTarget(outputsOnly);
            }
            final LinkedList<IScanTarget> queue = new LinkedList<IScanTarget>();
            queue.offer(target);
            while ((target = (IScanTarget)queue.poll()) != null) {
                if (DiscoveryCore.targetInProductRoot(target)) {
                    scan.getLogManager().log(new Message(4, Messages.getMessage("err.target.in.product.root", target.getName())));
                    continue;
                }
                boolean shouldAdd = target.findScanTargets(new IScanTargetCollector(){

                    public void add(IScanTarget newTarget) {
                        queue.offer(newTarget);
                    }
                }, progress);
                if (shouldAdd && scan.addScanTarget(target)) {
                    scan.getLogManager().log(new Message(1, Messages.getMessage("adding.target", target.getName())));
                    ++count;
                }
                if (!new File(target.getPath()).isFile()) continue;
                DiscoveryCore.getThirdPartyLibTarget().inject(target.getPath());
            }
        }
        return count;
    }

    private static boolean targetInProductRoot(IScanTarget target) {
        File targetLocation;
        File productRoot = new File(CommonCore.getDirectoryLocator().getProductRoot());
        return (PathUtil.isParent((File)productRoot, (File)(targetLocation = new File(target.getPath()))) || productRoot.equals(targetLocation)) && !targetLocation.getPath().contains("temp");
    }

    public static boolean isTopLevelTarget(File file) {
        return s_topLevelTargets.contains(file.getAbsolutePath());
    }
}

