/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.dir;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.dir.ICollector;
import com.ibm.appscan.discovery.dir.ICustomCollector;
import com.ibm.appscan.discovery.dir.NestingUtil;
import com.ibm.appscan.discovery.util.ThirdPartyDirUtil;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.internal.discovery.dir.CollectorFactoryRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class CrawlingStrategy
extends Strategy {
    private String m_path;
    private File m_realRoot;
    private IStrategyFactoryRegistry m_registry;

    @Override
    public void init(File root, IStrategyFactoryRegistry registry) {
        this.m_path = root.getPath();
        this.m_realRoot = new File(NestingUtil.getNestedPart(this.m_path));
        this.m_registry = registry;
    }

    protected void setRealRoot(File realRoot) {
        this.m_realRoot = realRoot;
    }

    protected File getRoot(IScanTargetMinProxy proxy) {
        if (!NestingUtil.isNestedPath(this.m_path)) {
            return this.m_realRoot;
        }
        ScanTargetStrategy parent = this.getParent();
        String relPath = this.m_realRoot.getPath();
        File staging = parent.getStagingDirectory(true);
        File file = new File(staging, relPath);
        if (!file.exists()) {
            try {
                ArchiveUtil.unzip((File)((CrawlingStrategy)parent).getRoot(proxy), (File)staging, (String[])new String[0]);
            }
            catch (AppScanException | IOException e) {
                proxy.getErrorManager().reportError(e.getMessage(), e);
            }
        }
        return file;
    }

    public String getName() {
        if ("".equals(this.m_realRoot.getName())) {
            return "ROOT";
        }
        return this.m_realRoot.getName();
    }

    public String getPath() {
        return this.m_path;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        File crawlRoot = this.getCrawlRoot(proxy);
        DirectoryVisitor visitor = new DirectoryVisitor(crawlRoot, proxy, progress);
        try {
            DirectoryUtil.walk((File)crawlRoot, (DirectoryUtil.TreeVisitor)visitor);
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        Set scanFiles = visitor.getScanFiles(this);
        Iterator iterator = scanFiles.iterator();
        while (iterator.hasNext()) {
            IScanFile scanFile;
            scanFile.setExcluded((scanFile = (IScanFile)iterator.next()).isExcluded() || this.isThirdPartyExclusion(scanFile, proxy));
        }
        return scanFiles;
    }

    protected abstract File getCrawlRoot(IScanTargetMinProxy var1);

    protected String[] getCategories(IBuildInfo buildInfo) {
        return null;
    }

    protected boolean shouldVisit(File directory) {
        return !ThirdPartyDirUtil.isThirdPartyDir(directory) || SystemUtil.isThirdParty();
    }

    protected boolean handle(File file, String path, IScanTargetMinProxy proxy) {
        return false;
    }

    protected void createScanTarget(IScanTargetProxy proxy, ScanTargetStrategy strategy) {
        proxy.newScanTarget(strategy);
    }

    protected boolean isThirdPartyExclusion(IScanFile scanFile, IScanTargetMinProxy proxy) {
        String lang = this.getLanguageType();
        if (lang != null) {
            try {
                BaseExclusion exclusionProvider = ExclusionProvider.getExclusion((String)lang);
                if (exclusionProvider != null) {
                    return exclusionProvider.isFileExcluded(scanFile.getFile());
                }
            }
            catch (ExclusionException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private class DirectoryVisitor
    extends DirectoryUtil.TreeVisitor {
        private IScanTargetProxy m_proxy;
        private IProgress m_progress;
        private List<ICollector> m_collectors;

        private DirectoryVisitor(File crawlRoot, IScanTargetMinProxy proxy, IProgress progress) {
            this.m_proxy = (IScanTargetProxy)proxy;
            this.m_progress = progress;
            this.m_collectors = CollectorFactoryRegistry.getCollectors(CrawlingStrategy.this.getCategories(proxy.getBuildInfo()), crawlRoot, this.m_proxy);
        }

        private File adjustForNesting(File file, String path) {
            if (NestingUtil.isNestedPath(CrawlingStrategy.this.m_path) || CrawlingStrategy.this.m_realRoot.isFile()) {
                return new File(CrawlingStrategy.this.m_path + '!' + path);
            }
            return file;
        }

        private boolean checkIsTarget(File fileOrDirectory, String path) {
            if (CrawlingStrategy.this.m_registry != null) {
                File adjusted = this.adjustForNesting(fileOrDirectory, path);
                ScanTargetStrategy strategy = CrawlingStrategy.this.m_registry.getStrategy(adjusted);
                if (strategy != null) {
                    CrawlingStrategy.this.createScanTarget(this.m_proxy, strategy);
                    return true;
                }
            }
            return false;
        }

        protected boolean preVisitDirectory(File directory) throws IOException {
            if (this.m_progress.isCanceled()) {
                return false;
            }
            String path = this.getCurrentPath();
            return path.isEmpty() || !directory.equals(this.m_proxy.getScanHome()) && CrawlingStrategy.this.shouldVisit(directory) && !this.checkIsTarget(directory, path);
        }

        protected boolean visitFile(File file) throws IOException {
            if (this.m_progress.isCanceled()) {
                return false;
            }
            String path = this.getCurrentPath();
            if (!CrawlingStrategy.this.handle(file, path, (IScanTargetMinProxy)this.m_proxy) && !this.checkIsTarget(file, path)) {
                for (ICollector collector : this.m_collectors) {
                    collector.process(file, path, this.m_progress);
                }
            } else {
                for (ICollector collector : this.m_collectors) {
                    if (!(collector instanceof ICustomCollector) || !((ICustomCollector)collector).getType().equals("ThirdPartyLibCollector")) continue;
                    collector.process(file, path, this.m_progress);
                    break;
                }
            }
            return true;
        }

        private Set<IScanFile> getScanFiles(ScanTargetStrategy parentStrategy) {
            LinkedHashSet<IScanFile> files = new LinkedHashSet<IScanFile>();
            for (ICollector collector : this.m_collectors) {
                if (collector instanceof ICustomCollector) {
                    ((ICustomCollector)collector).createScanTarget(this.m_proxy, parentStrategy);
                    continue;
                }
                Set<IScanFile> scanFiles = collector.getScanFiles();
                if (!this.m_proxy.isExcludedTarget() && SystemUtil.isDryRun()) {
                    collector.validateScanFiles((IScanTargetMinProxy)this.m_proxy, this.m_progress, scanFiles);
                }
                files.addAll(scanFiles);
            }
            return files;
        }
    }
}

