/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;

public class ThirdPartyDirUtil {
    private static List<String> m_knownThirdParty = Arrays.asList("node_modules", "bower_components");
    private static final String GO_MOD = "go.mod";
    private static final String COMPOSER_JSON = "composer.json";

    public static boolean isThirdPartyDir(File dir) {
        if (m_knownThirdParty.contains(dir.getName().toLowerCase())) {
            return true;
        }
        if (dir.getName().equalsIgnoreCase("pkg")) {
            return ThirdPartyDirUtil.siblingExists(dir, GO_MOD);
        }
        if (dir.getName().equalsIgnoreCase("vendor")) {
            return ThirdPartyDirUtil.siblingExists(dir, COMPOSER_JSON);
        }
        return false;
    }

    private static boolean siblingExists(File dir, String sibling) {
        File siblingFile = new File(dir.getParent(), sibling);
        return siblingFile.isFile();
    }
}

