/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.util.ServiceLoader;

public class StrategyFactoryRegistry
implements IStrategyFactoryRegistry {
    private static final ServiceLoader<IStrategyFactory> LOADER = ServiceLoader.load(IStrategyFactory.class);
    private boolean m_useAlternatives = false;

    public ScanTargetStrategy getStrategy(File fileOrDirectory, StrategyType type) {
        if (SystemUtil.isOpenSourceOnly()) {
            return null;
        }
        for (IStrategyFactory factory : LOADER) {
            Strategy strategy;
            boolean isBuildOutput = factory.isBuildOutput();
            if (isBuildOutput && (type == StrategyType.NON_OUTPUTS || SystemUtil.isSourceCodeOnly()) || !isBuildOutput && type == StrategyType.OUTPUTS || (strategy = factory.createStrategy(fileOrDirectory, this)) == null) continue;
            return strategy;
        }
        return null;
    }

    @Override
    public ScanTargetStrategy getStrategy(File fileOrDirectory) {
        return this.getStrategy(fileOrDirectory, StrategyType.OUTPUTS);
    }

    public void loadUniqueTargets(IScan scan) {
        for (IStrategyFactory factory : LOADER) {
            factory.loadUniqueTarget(scan);
        }
    }

    @Override
    public boolean useAlternativeStrategy() {
        return this.m_useAlternatives;
    }

    public void useAlternativeStrategies(boolean b) {
        this.m_useAlternatives = b;
    }

    public static enum StrategyType {
        ALL,
        OUTPUTS,
        NON_OUTPUTS;

    }
}

