/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.dir;

import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.ICollector;
import com.ibm.appscan.discovery.dir.ICollectorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class CollectorFactoryRegistry {
    public static final String CATEGORIES = "categories";
    private static final Map<String, ICollectorFactory> FACTORIES = new Hashtable<String, ICollectorFactory>();

    public static Set<String> getCategories() {
        return Collections.unmodifiableSet(FACTORIES.keySet());
    }

    public static Set<String> getDefaultCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Map.Entry<String, ICollectorFactory> entry : FACTORIES.entrySet()) {
            if (!entry.getValue().includeInDefault()) continue;
            categories.add(entry.getKey());
        }
        return categories;
    }

    public static String getLabel(String category) {
        ICollectorFactory factory = FACTORIES.get(category);
        return factory == null ? null : factory.getCategoryLabel();
    }

    public static List<ICollector> getCollectors(String[] categories, File crawlRoot, IScanTargetProxy proxy) {
        ICollector collector;
        ICollectorFactory factory;
        ArrayList<ICollector> collectors = new ArrayList<ICollector>();
        if (!SystemUtil.isOpenSourceOnly()) {
            if (categories == null) {
                for (ICollectorFactory factory2 : FACTORIES.values()) {
                    ICollector collector2;
                    if (!factory2.includeInDefault() || (collector2 = factory2.createCollector(crawlRoot, proxy)) == null) continue;
                    collectors.add(collector2);
                }
            } else {
                for (String category : categories) {
                    ICollector collector3;
                    ICollectorFactory factory3 = FACTORIES.get(category);
                    if (factory3 == null || (collector3 = factory3.createCollector(crawlRoot, proxy)) == null) continue;
                    collectors.add(collector3);
                }
            }
        }
        if ((factory = FACTORIES.get("category.thirdpartylib")) != null && (collector = factory.createCollector(crawlRoot, proxy)) != null) {
            collectors.add(collector);
        }
        return collectors;
    }

    private CollectorFactoryRegistry() {
    }

    static {
        ServiceLoader<ICollectorFactory> loader = ServiceLoader.load(ICollectorFactory.class);
        for (ICollectorFactory factory : loader) {
            FACTORIES.put(factory.getCategory(), factory);
        }
    }
}

