/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.ejb2xhandler;

import com.ibm.appscan.frameworks.highlevelapi.ejb2xhandler.BeanInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.PreNamespaceContext;
import com.ibm.appscan.frameworks.util.SchemaUtils;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EjbConfigInfo {
    private static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/j2ee";
    private String ejbConfigFile;
    private static final Logger logger = TaintLogger.i().getLogger();
    private boolean correctParsing;
    private boolean useExternalDTD;
    List<BeanInfo> ejBean = new ArrayList<BeanInfo>();

    public static EjbConfigInfo make(String ejbConfig, boolean useExternalDTD) throws XPathExpressionException {
        return new EjbConfigInfo(ejbConfig, useExternalDTD);
    }

    private EjbConfigInfo(String ejbConfig, boolean isUseExternalDTD) throws XPathExpressionException {
        this.ejbConfigFile = ejbConfig;
        this.useExternalDTD = isUseExternalDTD;
        Document doc = this.parseInputFile(this.ejbConfigFile);
        if (doc != null) {
            this.fillBeanInfo(doc);
            this.correctParsing = true;
        } else {
            logger.warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.ejbConfigFile}));
            this.correctParsing = false;
        }
    }

    public boolean isParsingSuccess() {
        return this.correctParsing;
    }

    private void fillBeanInfo(Document doc) throws XPathExpressionException {
        try {
            XPath xpath = this.createXPath();
            Properties result = new Properties();
            XPathExpression propertyExpr = xpath.compile("//pre:enterprise-beans/*");
            Object beansObject = propertyExpr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)beansObject;
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node bean = nodes.item(j);
                this.addBean(bean, xpath);
            }
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    public List<BeanInfo> getBeans() {
        return this.ejBean;
    }

    private void addBean(Node inBean, XPath xpath) throws XPathExpressionException {
        Node ejbName = (Node)xpath.compile("pre:ejb-name/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node home = (Node)xpath.compile("pre:home/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node remote = (Node)xpath.compile("pre:remote/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node local = (Node)xpath.compile("pre:local/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node localHome = (Node)xpath.compile("pre:local-home/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node ejbClass = (Node)xpath.compile("pre:ejb-class/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        Node endpoint = (Node)xpath.compile("pre:service-endpoint/text()").evaluate(inBean.getChildNodes(), XPathConstants.NODE);
        BeanInfo newBean = new BeanInfo();
        if (ejbName != null) {
            newBean.setEjbName(ejbName.getNodeValue());
        }
        if (home != null) {
            newBean.setHomeClass(home.getNodeValue());
        }
        if (local != null) {
            newBean.setLocalClass(local.getNodeValue());
        }
        if (endpoint != null) {
            newBean.setEndpointClass(endpoint.getNodeValue());
            newBean.setConfigFilePath(this.ejbConfigFile);
        }
        if (localHome != null) {
            newBean.setLocalHomeClass(localHome.getNodeValue());
        }
        if (remote != null) {
            newBean.setRemoteClass(remote.getNodeValue());
        }
        if (ejbClass != null) {
            newBean.setEjbClass(ejbClass.getNodeValue());
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.bean.found", (Object[])new Object[]{ejbName + " class: " + ejbClass}));
        this.ejBean.add(newBean);
    }

    private XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)new PreNamespaceContext(NAMESPACE_URI));
        return xpath;
    }

    private Document parseInputFile(String inputFilename) {
        logger.info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{inputFilename}));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            if (!this.useExternalDTD) {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(inputFilename));
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            return null;
        }
        catch (SAXException e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            return null;
        }
        catch (IOException e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            return null;
        }
        try {
            URL inputSchemaFile = this.getClass().getClassLoader().getResource("ejb-jar_2_1.xsd");
            if (inputSchemaFile != null) {
                SchemaUtils.validateDocumentAgainstSchema((Document)doc, (URL)inputSchemaFile);
            }
        }
        catch (SAXException e) {
            logger.warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inputFilename}));
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        catch (IOException e) {
            logger.warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inputFilename}));
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inputFilename}));
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return doc;
    }
}

