/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.GetReportHandler;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.json.JSONException;

public class GetResultHandler
extends SAHandler {
    public static final String ZIP_TYPE = "zip";
    public static final String COMPLIANCE_PDF_TYPE = "CompliancePdf";
    private String m_destination = null;

    public void getResult(String scanId, String type, String destination) throws AppScanException {
        this.doGetResult(StringUtil.getCleanUuid((String)scanId), type, destination);
    }

    private void doGetResult(String scanId, String type, String destination) {
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        try {
            if (this.isTokenExpired()) {
                return;
            }
            if (type == null) {
                type = "html";
            }
            if (!(type = type.toLowerCase()).equalsIgnoreCase("html") && !type.equalsIgnoreCase(ZIP_TYPE)) {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getresults.unknown.type", type)));
                return;
            }
            this.m_destination = destination != null ? destination : System.getProperty("user.dir");
            String fileName = new File(this.m_destination).getName();
            if (!FileUtil.isValidFilename((String)fileName)) {
                Message message = new Message(4, Messages.getMessage("err.invalid.characters", fileName));
                this.getProgressAdapter().setStatus(message);
                return;
            }
            File dest = new File(this.m_destination);
            if (!this.getReport(scanId, type, dest)) {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getresults.error", new Object[0])));
            }
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getresults.error", new Object[0])));
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }

    private boolean getReport(String scanId, String type, File destination) throws IOException, JSONException {
        if (type.equalsIgnoreCase("html")) {
            try {
                new GetReportHandler().getResult(scanId, "security", "scan", destination.getAbsolutePath(), type, null, "AppScan Security Report", "en");
            }
            catch (AppScanException | JSONException e) {
                this.getProgressAdapter().setStatus(new Message(e));
                return false;
            }
            return true;
        }
        return this.getRawResult(scanId, type, destination);
    }
}

