/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.handlers.EntitlementHandler;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.cloud.handlers.FileHandler;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.PackageUtil;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.VersionUtil;
import com.ibm.security.annotation.ValidatorMethod;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Locale;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class QueueAnalysisHandler
extends SAHandler {
    private boolean m_personalScan;
    private boolean m_email;
    private String m_comment;
    private boolean m_disableIntervention = false;
    private boolean m_ranSastScan = false;
    private boolean m_ranScaScan = false;
    private String m_sastScanId = null;
    private String m_scaScanId = null;

    public QueueAnalysisHandler() {
        this.m_progress = new ProgressAdapter();
        this.m_personalScan = false;
        this.m_email = true;
        this.m_comment = null;
    }

    public void setPersonalScan(boolean personalScan) {
        this.m_personalScan = personalScan;
    }

    public void setEmail(boolean email) {
        this.m_email = email;
    }

    public void setDisableIntervention(boolean intervention) {
        this.m_disableIntervention = intervention;
    }

    void setTestAuthProvider(AuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    public void setComment(String comment) {
        this.m_comment = this.validateAndSanitize(comment);
    }

    public String getJobID() {
        return this.m_sastScanId;
    }

    public String getSCAJobID() {
        return this.m_scaScanId;
    }

    public void queueAnalysis(String scanName, String inputScanFile, String appId) {
        try {
            if (this.m_authProvider.isTokenExpired()) {
                this.m_progress.setStatus(new Message(4, com.ibm.appscan.cli.cloud.auth.Messages.getMessage((String)"login.token.expired", (Object[])new Object[0])));
                return;
            }
            if ("SCX".equalsIgnoreCase(this.m_authProvider.getApiEnvironment())) {
                if (appId == null) {
                    this.m_progress.setStatus(new Message(4, Messages.getMessage("err.no.appid", new Object[0])));
                    return;
                }
                this.setAppId(appId);
            }
            File fileToUpload = null;
            if (inputScanFile == null) {
                fileToUpload = this.findScanFile();
            } else if (this.isValidScanFile(inputScanFile)) {
                fileToUpload = new File(inputScanFile);
            } else {
                Message message = new Message(4, Messages.getMessage("err.irx.invalid", inputScanFile));
                this.m_progress.setStatus(message);
                return;
            }
            if (fileToUpload != null) {
                Message error;
                if (!this.versionCheck(fileToUpload)) {
                    return;
                }
                if (scanName == null) {
                    scanName = fileToUpload.getName().substring(0, fileToUpload.getName().lastIndexOf("."));
                }
                this.executeRequest(fileToUpload, scanName);
                IConsole console = CommonCLICore.getIOConsole();
                if (this.m_scaScanId != null) {
                    console.println(Messages.getMessage("job.sca.job.id", this.m_scaScanId));
                } else if (this.m_ranScaScan) {
                    error = new Message(4, Messages.getMessage("job.sca.upload.error", new Object[0]));
                    this.m_progress.setStatus(error);
                }
                if (this.m_sastScanId != null) {
                    console.println(Messages.getMessage("job.sast.job.id", this.m_sastScanId));
                } else if (this.m_ranSastScan) {
                    error = new Message(4, Messages.getMessage("job.sast.upload.error", new Object[0]));
                    this.m_progress.setStatus(error);
                }
            }
        }
        catch (SSLHandshakeException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.ssl", this.m_authProvider.getServer())));
        }
        catch (JSONException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (AppScanException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
    }

    private void executeRequest(File file, String scanName) throws IOException, JSONException, AppScanException {
        String fileId = new FileHandler().uploadFile(file);
        if (fileId != null) {
            JSONObject content;
            if ("0".equals(this.m_appID)) {
                this.initDefaultApp(Messages.getMessage("default.app", new Object[0]));
            }
            if (this.shouldRunSastScan(file)) {
                this.m_ranSastScan = true;
                content = this.createAndExecuteSastScan(fileId, scanName, Boolean.toString(this.m_email), Locale.getDefault().toString().replace('_', '-'), Boolean.toString(this.m_personalScan), this.m_comment, this.m_disableIntervention);
                if (content != null && content.containsKey((Object)"Id")) {
                    this.m_sastScanId = StringUtil.getCleanUuid((String)content.getString("Id"));
                }
            }
            if (this.shouldRunScaScan(file)) {
                this.m_ranScaScan = true;
                content = this.createAndExecuteScaScan(fileId, scanName, Boolean.toString(this.m_email), Locale.getDefault().toString().replace('_', '-'), Boolean.toString(this.m_personalScan), this.m_comment, this.m_disableIntervention);
                if (content != null && content.containsKey((Object)"Id")) {
                    this.m_scaScanId = StringUtil.getCleanUuid((String)content.getString("Id"));
                }
            }
        }
    }

    private File findScanFile() {
        File currentDir = new File(System.getProperty("user.dir"));
        File[] sourceFiles = currentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || !file.isFile()) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith(".irx");
            }
        });
        if (sourceFiles.length < 1) {
            Message message = new Message(4, Messages.getMessage("err.irx.none", new Object[0]));
            CommonCLICore.getIOConsole().println(message);
        } else if (sourceFiles.length > 1) {
            Message message = new Message(4, Messages.getMessage("err.irx.multiple", new Object[0]));
            CommonCLICore.getIOConsole().println(message);
        } else {
            return sourceFiles[0];
        }
        return null;
    }

    private boolean isValidScanFile(String inputFile) {
        return new File(inputFile).isFile() && (inputFile.endsWith(".irx") || SystemUtil.isSupportedArchive((String)inputFile));
    }

    @ValidatorMethod
    private String validateAndSanitize(String comment) {
        if (comment != null) {
            comment = comment.replaceAll("[\\\\^${}^`\\<>]", "");
        }
        return comment;
    }

    private boolean versionCheck(File scanFile) throws IOException {
        if (!scanFile.getName().endsWith(".irx")) {
            return true;
        }
        String localVersion = VersionUtil.getLocalToolsVersion();
        String scanVersion = PackageUtil.getVersion((File)scanFile);
        String serverVersion = VersionUtil.getServerToolsVersion();
        if (scanVersion == null || serverVersion == null || localVersion == null) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("err.version.check.failed", new Object[0])));
            return true;
        }
        int scanState = VersionUtil.compareWithLatest((String)scanVersion);
        int localState = VersionUtil.compareWithLatest((String)localVersion);
        if (localState == 2) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("warn.version.tools.mismatch", VersionUtil.getUtilityDownloadURL())));
        } else if (localState == 3) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("err.version.tools.mismatch", VersionUtil.getUtilityDownloadURL())));
        }
        if (scanState == 2) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("warn.version.irx.mismatch", VersionUtil.getUtilityDownloadURL())));
        } else if (scanState == 3) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("err.version.irx.mismatch", VersionUtil.getUtilityDownloadURL())));
            return false;
        }
        return true;
    }

    private boolean shouldRunSastScan(File scanFile) throws IOException, JSONException {
        return !FileUtil.getFileExtension((File)scanFile).equalsIgnoreCase("irx") || !SystemUtil.isOpenSourceOnly() && !PackageUtil.isOpenSourceOnly((File)scanFile) && new EntitlementHandler().hasSASTEntitlement();
    }

    private boolean shouldRunScaScan(File scanFile) throws IOException, JSONException {
        return FileUtil.getFileExtension((File)scanFile).equalsIgnoreCase("irx") && !SystemUtil.isStaticAnalysisOnly() && !PackageUtil.isStaticAnalysisOnly((File)scanFile) && new EntitlementHandler().hasOpenSourceEntitlement();
    }
}

