/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarVisitor;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.IVariable;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractGrammar
implements IGrammar {
    @Override
    public void traverseSymbols(final ISymbolVisitor visitor) {
        if (this.getStartSymbol() != null) {
            this.getStartSymbol().traverse(visitor);
        }
        this.traverseRules(new IRuleVisitor(){

            @Override
            public void onVisit(IProductionRule rule) {
                rule.traverseSymbols(visitor);
            }
        });
    }

    @Override
    public void traverseRules(IRuleVisitor visitor) {
        for (IProductionRule rule : this.getRules()) {
            rule.traverse(visitor);
        }
    }

    @Override
    public void traverse(IGrammarVisitor visitor) {
        visitor.onVisit(this);
        this.traverseSymbols(visitor);
        this.traverseRules(visitor);
    }

    @Override
    public Set<IVariable> getNonterminals() {
        HashSet<IVariable> l = new HashSet<IVariable>();
        l.add(this.getStartSymbol());
        for (IProductionRule rule : this.getRules()) {
            l.add(rule.getLeft());
            for (ISymbol s : rule.getRight()) {
                if (!(s instanceof IVariable)) continue;
                l.add((IVariable)s);
            }
        }
        return l;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

