/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolFactory;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.automaton.string.Transition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RRTNRegularApproximation {
    public static IContextFreeGrammar toRegularGrammar(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        IAutomaton fst = Grammars.toAutomaton(cfg, varFactory);
        return Grammars.toCFG(fst, varFactory);
    }

    public static IAutomaton toSingletonAutomaton(SingletonGrammar sg, IVariableFactory<IVariable> varFactory) {
        IValueSymbol[] v = sg.getTheValue();
        List<IValueSymbol> symList = Arrays.asList(v);
        return Automatons.createAutomaton(symList);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        if (cfg instanceof SingletonGrammar) {
            return RRTNRegularApproximation.toSingletonAutomaton((SingletonGrammar)cfg, varFactory);
        }
        IContextFreeGrammar ncfg = (IContextFreeGrammar)cfg.copy(SimpleGrammarCopier.defaultCopier);
        Grammars.simplifyRules(ncfg, varFactory);
        final FreshStateFactory sf = new FreshStateFactory();
        DMap<IVariable, IState> iniMapL = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        DMap<IVariable, IState> finMapL = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        DMap<IVariable, IState> iniMapR = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        DMap<IVariable, IState> finMapR = new DMap<IVariable, IState>(new DMap.Factory<IVariable, IState>(){

            @Override
            public IState create(IVariable key) {
                return sf.createState("s");
            }
        });
        IAutomaton fst = RRTNRegularApproximation.toAutomaton(ncfg, iniMapL, finMapL, iniMapR, finMapR, sf);
        Automatons.eliminateEpsilonTransitions(fst);
        Automatons.eliminateUnreachableStates(fst);
        return fst;
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg) {
        return RRTNRegularApproximation.toAutomaton(cfg, new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg));
    }

    private static IAutomaton toAutomaton(IContextFreeGrammar ncfg, Map<IVariable, IState> iniMapL, Map<IVariable, IState> finMapL, Map<IVariable, IState> iniMapR, Map<IVariable, IState> finMapR, IStateFactory sf) {
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        for (IProductionRule r : ncfg.getRules()) {
            RRTNRegularApproximation.constructTransitions(r, transitions, iniMapL, finMapL, iniMapR, finMapR, sf);
        }
        IVariable svar = ncfg.getStartSymbol();
        HashSet<IState> finalStates = new HashSet<IState>();
        finalStates.add(finMapL.get(svar));
        finalStates.add(finMapR.get(svar));
        IState s = sf.createState("s");
        transitions.add(new Transition(s, iniMapL.get(svar)));
        transitions.add(new Transition(s, iniMapR.get(svar)));
        Automaton result = new Automaton(s, finalStates, transitions);
        return Automatons.minimize(result);
    }

    private static void constructTransitions(IProductionRule r, Set<ITransition> transitions, Map<IVariable, IState> iniMapL, Map<IVariable, IState> finMapL, Map<IVariable, IState> iniMapR, Map<IVariable, IState> finMapR, IStateFactory sf) {
        int rsize = r.getRight().size();
        switch (rsize) {
            case 0: {
                IVariable lv = r.getLeft();
                Transition t1l = new Transition(iniMapL.get(lv), finMapL.get(lv));
                transitions.add(t1l);
                Transition t1r = new Transition(iniMapR.get(lv), finMapR.get(lv));
                transitions.add(t1r);
                break;
            }
            case 1: {
                IVariable lv = r.getLeft();
                ISymbol rv = r.getRight(0);
                if (rv instanceof IVariable) {
                    Transition t1ll = new Transition(iniMapL.get(lv), iniMapL.get(rv));
                    Transition t2ll = new Transition(finMapL.get(rv), finMapL.get(lv));
                    transitions.add(t1ll);
                    transitions.add(t2ll);
                    Transition t1rr = new Transition(iniMapR.get(lv), iniMapR.get(rv));
                    Transition t2rr = new Transition(finMapR.get(rv), finMapR.get(lv));
                    transitions.add(t1rr);
                    transitions.add(t2rr);
                    break;
                }
                Transition t1l = new Transition(iniMapL.get(lv), finMapL.get(lv), rv);
                transitions.add(t1l);
                Transition t1r = new Transition(iniMapR.get(lv), finMapR.get(lv), rv);
                transitions.add(t1r);
                break;
            }
            case 2: {
                IVariable lv = r.getLeft();
                ISymbol r0 = r.getRight(0);
                ISymbol r1 = r.getRight(1);
                if (r0 instanceof IVariable) {
                    if (r1 instanceof IVariable) {
                        Transition t0l = new Transition(iniMapL.get(lv), iniMapL.get(r0));
                        Transition t1l = new Transition(finMapL.get(r0), iniMapR.get(r1));
                        Transition t2l = new Transition(finMapR.get(r1), finMapL.get(lv));
                        transitions.add(t0l);
                        transitions.add(t1l);
                        transitions.add(t2l);
                        Transition t0r = new Transition(iniMapR.get(lv), iniMapL.get(r0));
                        Transition t1r = new Transition(finMapL.get(r0), iniMapR.get(r1));
                        Transition t2r = new Transition(finMapR.get(r1), finMapR.get(lv));
                        transitions.add(t0r);
                        transitions.add(t1r);
                        transitions.add(t2r);
                        break;
                    }
                    Transition t0l = new Transition(iniMapL.get(lv), iniMapL.get(r0));
                    Transition t1l = new Transition(finMapL.get(r0), finMapL.get(lv), r1);
                    transitions.add(t0l);
                    transitions.add(t1l);
                    Transition t0r = new Transition(iniMapR.get(lv), iniMapR.get(r0));
                    Transition t1r = new Transition(finMapR.get(r0), finMapR.get(lv), r1);
                    transitions.add(t0r);
                    transitions.add(t1r);
                    break;
                }
                if (r1 instanceof IVariable) {
                    Transition t0l = new Transition(iniMapL.get(lv), iniMapL.get(r1), r0);
                    Transition t1l = new Transition(finMapL.get(r1), finMapL.get(lv));
                    transitions.add(t0l);
                    transitions.add(t1l);
                    Transition t0r = new Transition(iniMapR.get(lv), iniMapR.get(r1), r0);
                    Transition t1r = new Transition(finMapR.get(r1), finMapR.get(lv));
                    transitions.add(t0r);
                    transitions.add(t1r);
                    break;
                }
                IState sl = sf.createState("s");
                Transition t0l = new Transition(iniMapL.get(lv), sl, r0);
                Transition t1l = new Transition(sl, finMapL.get(lv), r1);
                transitions.add(t0l);
                transitions.add(t1l);
                IState sr = sf.createState("s");
                Transition t0r = new Transition(iniMapR.get(lv), sr, r0);
                Transition t1r = new Transition(sr, finMapR.get(lv), r1);
                transitions.add(t0r);
                transitions.add(t1r);
                break;
            }
            default: {
                throw new RuntimeException("size of rule shold be less than 3.: " + r);
            }
        }
    }
}

