/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.grammar.tree.RTLAbstractTranslator;
import com.ibm.wala.automaton.grammar.tree.TreeGrammar;
import com.ibm.wala.automaton.grammar.tree.TreeGrammars;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.tree.BinaryTree;
import com.ibm.wala.automaton.tree.BinaryTreeVariable;
import com.ibm.wala.automaton.tree.BottomUpTreeAutomaton;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import com.ibm.wala.automaton.tree.StateBinaryTree;
import java.util.HashSet;
import java.util.Set;

public class RTLBottomUpTranslator
extends RTLAbstractTranslator {
    public RTLBottomUpTranslator(BottomUpTreeAutomaton automaton) {
        super(automaton);
    }

    @Override
    public ITreeGrammar translate(ITreeGrammar g) {
        IBinaryTree bt;
        g = (ITreeGrammar)g.copy(SimpleGrammarCopier.defaultCopier);
        TreeGrammars.normalize(g);
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        RTLAbstractTranslator.StateVariable2Name sv2name = new RTLAbstractTranslator.StateVariable2Name(g);
        Set<IState> pstates = this.getPrimitiveStates();
        for (IState lstate : pstates) {
            for (IState rstate : pstates) {
                for (IProductionRule rule : g.getRules()) {
                    bt = (IBinaryTree)rule.getRight(0);
                    if (bt instanceof IParentBinaryTree) {
                        IParentBinaryTree pbt = (IParentBinaryTree)bt;
                        StateBinaryTree lbt = new StateBinaryTree(lstate, new BinaryTreeVariable(sv2name.get(lstate, (IBinaryTreeVariable)pbt.getLeft())));
                        StateBinaryTree rbt = new StateBinaryTree(rstate, new BinaryTreeVariable(sv2name.get(rstate, (IBinaryTreeVariable)pbt.getLeft())));
                        bt = new BinaryTree(bt.getLabel(), (IBinaryTree)lbt, (IBinaryTree)rbt);
                    }
                    Set<IProductionRule> rs = this.translate((IBinaryTreeVariable)rule.getLeft(), bt, sv2name);
                    HashSet<ProductionRule> rs2 = new HashSet<ProductionRule>();
                    for (IProductionRule r : rs) {
                        StateBinaryTree sv = (StateBinaryTree)r.getRight(0);
                        StateBinaryTree sv2 = new StateBinaryTree(sv.getState(), (IBinaryTreeVariable)rule.getLeft());
                        String vname = sv2name.get(sv2);
                        if (vname == null) {
                            throw new AssertionError((Object)"should not be null.");
                        }
                        BinaryTreeVariable v = new BinaryTreeVariable(vname);
                        rs2.add(new ProductionRule((IVariable)v, (ISymbol)sv.getTree()));
                    }
                    rules.addAll(rs2);
                }
            }
        }
        Set<IState> finalStates = ((BottomUpTreeAutomaton)this.getSystem()).getFinalStates();
        for (IProductionRule rule : g.getRules()) {
            for (IState finState : finalStates) {
                IBinaryTreeVariable v = (IBinaryTreeVariable)rule.getLeft();
                bt = new BinaryTreeVariable(sv2name.get(finState, v));
                ProductionRule r = new ProductionRule((IVariable)v, (ISymbol)bt);
                rules.add(r);
            }
        }
        TreeGrammar result = new TreeGrammar((IBinaryTreeVariable)g.getStartSymbol(), rules);
        TreeGrammars.eliminateUselessRules(result);
        return result;
    }
}

