/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public class CharSetPatternFactory {
    private static final Map<String, Character[]> map = HashMapFactory.make((int)6);

    public static IPattern make(String charSetName) {
        Character[] chars = map.get(charSetName);
        assert (chars != null);
        return CharSetPatternFactory.makeUnionPattern(chars);
    }

    private static IPattern makeUnionPattern(Character[] C) {
        if (C.length <= 2) {
            if (C.length == 1) {
                return new SymbolPattern(C[0].charValue());
            }
            return new UnionPattern(new SymbolPattern(C[0].charValue()), new SymbolPattern(C[1].charValue()));
        }
        int length = C.length;
        int mid = length / 2;
        Character[] c1 = new Character[mid];
        for (int i = 0; i < mid; ++i) {
            c1[i] = C[i];
        }
        Character[] c2 = new Character[length - mid];
        for (int i = mid; i < length; ++i) {
            c2[i - mid] = C[i];
        }
        IPattern lhs = CharSetPatternFactory.makeUnionPattern(c1);
        IPattern rhs = CharSetPatternFactory.makeUnionPattern(c2);
        return new UnionPattern(lhs, rhs);
    }

    static {
        map.put("Pe", new Character[]{Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}')});
        map.put("Pi", new Character[]{Character.valueOf('\u00ab')});
        map.put("Pf", new Character[]{Character.valueOf('\u00bb')});
        map.put("Po", new Character[]{Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('\\'), Character.valueOf('\u00a1'), Character.valueOf('\u00b7'), Character.valueOf('\u00bf')});
        map.put("Ps", new Character[]{Character.valueOf('('), Character.valueOf('['), Character.valueOf('{')});
        map.put("S", new Character[]{Character.valueOf('$'), Character.valueOf('+'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~'), Character.valueOf('\u00a2'), Character.valueOf('\u00a3'), Character.valueOf('\u00a4'), Character.valueOf('\u00a5'), Character.valueOf('\u00a6'), Character.valueOf('\u00a7'), Character.valueOf('\u00a8'), Character.valueOf('\u00a9'), Character.valueOf('\u00ac'), Character.valueOf('\u00ae'), Character.valueOf('\u00af'), Character.valueOf('\u00b0'), Character.valueOf('\u00b1'), Character.valueOf('\u00b4'), Character.valueOf('\u00b6'), Character.valueOf('\u00b8'), Character.valueOf('\u00d7'), Character.valueOf('\u00f7')});
    }
}

