/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCopier;
import com.ibm.wala.automaton.regex.string.IPatternVisitor;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.string.CharSymbol;
import java.util.ArrayList;
import java.util.Collection;

public class ConcatenationPattern
extends AbstractPattern
implements IPattern {
    private IPattern head;
    private IPattern tail;

    public static IPattern make(IPattern left, IPattern right) {
        if (left.equals(EmptyPattern.singleton)) {
            return right;
        }
        if (right.equals(EmptyPattern.singleton)) {
            return left;
        }
        return new ConcatenationPattern(left, right);
    }

    public static IPattern make(Collection<? extends IPattern> patterns) {
        IPattern p = null;
        for (IPattern iPattern : patterns) {
            if (p == null) {
                p = iPattern;
                continue;
            }
            p = ConcatenationPattern.make(p, iPattern);
        }
        return p;
    }

    public static IPattern make(char[] cs) {
        ArrayList<SymbolPattern> patterns = new ArrayList<SymbolPattern>();
        for (int i = 0; i < cs.length; ++i) {
            SymbolPattern p = new SymbolPattern(new CharSymbol(cs[i]));
            patterns.add(p);
        }
        return ConcatenationPattern.make(patterns);
    }

    public ConcatenationPattern(IPattern head, IPattern tail) {
        this.head = head;
        this.tail = tail;
    }

    public IPattern getHead() {
        return this.head;
    }

    public IPattern getTail() {
        return this.tail;
    }

    public int hashCode() {
        return this.head.hashCode() + this.tail.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ConcatenationPattern p = (ConcatenationPattern)obj;
        return this.head.equals(p.getHead()) && this.tail.equals(p.getTail());
    }

    public String toString() {
        return "(" + this.head.toString() + this.tail.toString() + ")";
    }

    @Override
    public void traverse(IPatternVisitor visitor) {
        visitor.onVisit(this);
        this.head.traverse(visitor);
        this.tail.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public IPattern copy(IPatternCopier copier) {
        ArrayList<IPattern> l = new ArrayList<IPattern>();
        l.add(this.head.copy(copier));
        l.add(this.tail.copy(copier));
        return copier.copy(this, l);
    }
}

