/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCopier;
import com.ibm.wala.automaton.regex.string.IPatternVisitor;
import java.util.ArrayList;

public class IntersectionPattern
extends AbstractPattern
implements IPattern {
    private IPattern left;
    private IPattern right;

    public static IPattern make(IPattern left, IPattern right) {
        if (left.equals(EmptyPattern.singleton)) {
            return EmptyPattern.singleton;
        }
        if (right.equals(EmptyPattern.singleton)) {
            return EmptyPattern.singleton;
        }
        return new IntersectionPattern(left, right);
    }

    public IntersectionPattern(IPattern left, IPattern right) {
        this.left = left;
        this.right = right;
    }

    public IPattern getLeft() {
        return this.left;
    }

    public IPattern getRight() {
        return this.right;
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        IntersectionPattern p = (IntersectionPattern)obj;
        return this.left.equals(p.getLeft()) && this.right.equals(p.getRight());
    }

    public String toString() {
        return "(" + this.left.toString() + "&" + this.right.toString() + ")";
    }

    @Override
    public void traverse(IPatternVisitor visitor) {
        visitor.onVisit(this);
        this.left.traverse(visitor);
        this.right.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public IPattern copy(IPatternCopier copier) {
        ArrayList<IPattern> l = new ArrayList<IPattern>();
        l.add(this.left.copy(copier));
        l.add(this.right.copy(copier));
        return copier.copy(this, l);
    }
}

