/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.CFGSymbol;
import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IAutomatonSymbol;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.StringSymbol;
import java.util.List;

public class AutomatonSymbol
implements IAutomatonSymbol,
ILanguageSymbol<IAutomaton> {
    IAutomaton fst;

    public AutomatonSymbol(IAutomaton fst) {
        this.fst = fst;
    }

    @Override
    public IAutomaton getAutomaton() {
        return this.fst;
    }

    @Override
    public IAutomaton getLanguage() {
        return this.fst;
    }

    @Override
    public String getName() {
        return this.fst.toString();
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof AutomatonSymbol) {
            AutomatonSymbol sps = (AutomatonSymbol)symbol;
            if (Automatons.containsAll(this.fst, sps.fst)) {
                context.put(this, sps);
                return true;
            }
            return false;
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol strSym = (StringSymbol)symbol;
            List<CharSymbol> cs = strSym.toCharSymbols();
            if (this.fst.accept(cs)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfgSymbol = (CFGSymbol)symbol;
            if (CFLReachability.containsAll(this.fst, cfgSymbol.getGrammar(), null)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (this.fst.accept(AUtil.list(symbol))) {
            context.put(this, symbol);
            return true;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof AutomatonSymbol) {
            AutomatonSymbol sps = (AutomatonSymbol)symbol;
            if (Automatons.containsSome(sps.fst, this.fst)) {
                context.put(this, sps);
                return true;
            }
            return false;
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol strSym = (StringSymbol)symbol;
            List<CharSymbol> cs = strSym.toCharSymbols();
            if (this.fst.accept(cs)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfgSymbol = (CFGSymbol)symbol;
            if (CFLReachability.containsSome(cfgSymbol.getGrammar(), this.fst)) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        if (this.fst.accept(AUtil.list(symbol))) {
            context.put(this, symbol);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.fst.hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AutomatonSymbol ps = (AutomatonSymbol)obj;
        return this.fst.equals(ps.fst);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof AutomatonSymbol) {
            AutomatonSymbol ps = (AutomatonSymbol)s;
            if (copier instanceof ISTSCopier) {
                ISTSCopier scopier = (ISTSCopier)copier;
                ps.fst = (IAutomaton)scopier.copy(ps.fst);
            }
        }
        return s;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

