/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IEnumerableValueSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.ILabeledValueSymbol;
import com.ibm.wala.automaton.string.LabelSubstitution;
import com.ibm.wala.automaton.string.PairSymbol;
import com.ibm.wala.automaton.string.StringSymbol;

public class LabeledSymbol
extends PairSymbol
implements ILabeledValueSymbol {
    public LabeledSymbol(IEnumerableValueSymbol symbol, ILabelSymbol label) {
        super(symbol, label);
        assert (!(symbol instanceof LabeledSymbol));
        assert (label != null);
    }

    @Override
    public ILabelSymbol getLabel() {
        return (ILabelSymbol)this.getSecond();
    }

    @Override
    public IEnumerableValueSymbol getValueSymbol() {
        return (IEnumerableValueSymbol)this.getFirst();
    }

    @Override
    public StringSymbol stringSymbolValue() {
        return this.getValueSymbol().stringSymbolValue();
    }

    @Override
    public Object value() {
        return this.getValueSymbol().value();
    }

    @Override
    public IContextFreeGrammar getGrammar() {
        IContextFreeGrammar g = this.getValueSymbol().getGrammar();
        return new LabelSubstitution().substitute(g, this.getLabel());
    }

    @Override
    public IAutomaton getAutomaton() {
        return this.getValueSymbol().getAutomaton();
    }

    @Override
    public IEnumerableSymbol getMax() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getMax(), this.getLabel());
    }

    @Override
    public IEnumerableSymbol getMin() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getMin(), this.getLabel());
    }

    @Override
    public IEnumerableSymbol getTop() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getTop(), ILabelSymbol.TOP);
    }

    @Override
    public IEnumerableSymbol getBottom() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getBottom(), ILabelSymbol.BOTTOM);
    }

    @Override
    public IEnumerableSymbol getPred() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getPred(), this.getLabel());
    }

    @Override
    public IEnumerableSymbol getSucc() {
        return new LabeledSymbol((IEnumerableValueSymbol)this.getValueSymbol().getSucc(), this.getLabel());
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof LabeledSymbol) {
            LabeledSymbol other = (LabeledSymbol)o;
            if (this.getValueSymbol().compareTo(other.getValueSymbol()) > 0) {
                if (this.getLabel().compareTo(other.getLabel()) >= 0) {
                    return 1;
                }
                throw new IComparableSymbol.NotComparableException(this, o);
            }
            if (this.getValueSymbol().compareTo(other.getValueSymbol()) == 0) {
                return this.getLabel().compareTo(other.getLabel());
            }
            if (this.getLabel().compareTo(other.getLabel()) <= 0) {
                return -1;
            }
            throw new IComparableSymbol.NotComparableException(this, o);
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }

    @Override
    public int rangeCompareTo(IEnumerableSymbol s) {
        try {
            return this.compareTo(s);
        }
        catch (IComparableSymbol.NotComparableException e) {
            if (s instanceof LabeledSymbol) {
                LabeledSymbol l = (LabeledSymbol)s;
                try {
                    return this.getLabel().compareTo(l.getLabel());
                }
                catch (IComparableSymbol.NotComparableException e1) {
                    return this.getLabel().toString().compareTo(l.getLabel().toString());
                }
            }
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol other) {
        if (other instanceof LabeledSymbol) {
            LabeledSymbol ls = (LabeledSymbol)other;
            return new IComparableSymbol[]{ls.getValueSymbol(), this.getValueSymbol()};
        }
        return new IComparableSymbol[]{other, this.getValueSymbol()};
    }
}

