/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.LabelSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetSymbol<T>
extends LabelSymbol {
    private Set<T> elements;
    private int hashCode;

    public SetSymbol(T elem) {
        this((Collection<T>)Collections.singleton(elem));
    }

    public SetSymbol(Collection<T> elems) {
        this.elements = new HashSet<T>(elems);
        this.hashCode = 0;
    }

    public Collection<T> getElements() {
        return Collections.unmodifiableCollection(this.elements);
    }

    @Override
    public ILabelSymbol meet(ILabelSymbol l) {
        if (l instanceof SetSymbol) {
            SetSymbol other = (SetSymbol)l;
            HashSet<T> elems = new HashSet<T>();
            elems.addAll(this.elements);
            elems.addAll(other.elements);
            return new SetSymbol(elems);
        }
        if (l.isBottom()) {
            return this;
        }
        return ILabelSymbol.TOP;
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        return copier.copy(this);
    }

    @Override
    public String getName() {
        StringBuffer buff = new StringBuffer("[");
        Iterator<T> i = this.elements.iterator();
        while (i.hasNext()) {
            T elem = i.next();
            buff.append(elem);
            if (!i.hasNext()) continue;
            buff.append(",");
        }
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (this.equals(symbol)) {
            context.put(this, symbol);
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.elements.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetSymbol)) {
            return false;
        }
        SetSymbol other = (SetSymbol)obj;
        return this.elements.equals(other.elements);
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        return this.matches(symbol, context);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    public String toString() {
        return this.elements.toString();
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol other) throws IComparableSymbol.NotComparableException {
        throw new IComparableSymbol.NotComparableException(other, this);
    }

    public boolean isComparable(IComparableSymbol s) {
        return s instanceof SetSymbol;
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o.equals(ILabelSymbol.TOP)) {
            return -1;
        }
        if (o.equals(ILabelSymbol.BOTTOM)) {
            return 1;
        }
        if (o instanceof SetSymbol) {
            SetSymbol s = (SetSymbol)o;
            if (this.elements.containsAll(s.elements)) {
                if (s.elements.containsAll(this.elements)) {
                    return 0;
                }
                return 1;
            }
            if (s.elements.containsAll(this.elements)) {
                return -1;
            }
            return this.elements.toString().compareTo(s.elements.toString());
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }
}

