/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IEnumerableValueSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.string.Variable;
import java.util.ArrayList;
import java.util.List;

public class StringSymbol
extends Symbol
implements IEnumerableValueSymbol {
    public static final StringSymbol MIN = new StringSymbol("");
    public static final StringSymbol MAX = new SingularStringSymbol(){

        @Override
        public IEnumerableSymbol getPred() {
            return MAX;
        }

        @Override
        public IEnumerableSymbol getSucc() {
            return TOP;
        }
    };
    public static final StringSymbol TOP = new SingularStringSymbol(){

        @Override
        public IEnumerableSymbol getPred() {
            return MAX;
        }

        @Override
        public IEnumerableSymbol getSucc() {
            return TOP;
        }
    };
    public static final StringSymbol BOTTOM = new StringSymbol(""){

        @Override
        public IEnumerableSymbol getPred() {
            return BOTTOM;
        }

        @Override
        public IEnumerableSymbol getSucc() {
            return MIN;
        }
    };

    public StringSymbol(String name) {
        super(name);
    }

    @Override
    public String value() {
        return new String(this.getName());
    }

    public List<CharSymbol> toCharSymbols() {
        return StringSymbol.toCharSymbols(this.getName());
    }

    public List<ISymbol> toSymbols() {
        return StringSymbol.toSymbols(this.getName());
    }

    public static List<CharSymbol> toCharSymbols(String s) {
        ArrayList<CharSymbol> result = new ArrayList<CharSymbol>();
        char[] cs = s.toCharArray();
        if (cs.length != 0) {
            for (int i = 0; i < cs.length; ++i) {
                CharSymbol sym = new CharSymbol(cs[i]);
                result.add(sym);
            }
        }
        return result;
    }

    public static List<ISymbol> toSymbols(String s) {
        return new ArrayList<ISymbol>(StringSymbol.toCharSymbols(s));
    }

    @Override
    public StringSymbol stringSymbolValue() {
        return this;
    }

    @Override
    public SingletonGrammar getGrammar() {
        return new SingletonGrammar((IVariable)new Variable("STRING_SYM#" + this.hashCode()), this.toCharSymbols());
    }

    @Override
    public IAutomaton getAutomaton() {
        return Automatons.createAutomaton(this.toCharSymbols());
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof CharSymbol) {
            CharSymbol c = (CharSymbol)o;
            return new IComparableSymbol[]{new StringSymbol(Character.toString(c.charValue())), this};
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return new IComparableSymbol[]{new StringSymbol(n.value().toString()), this};
        }
        throw new IComparableSymbol.NotComparableException(this, o);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof StringSymbol) {
            StringSymbol s = (StringSymbol)o;
            return this.getName().compareTo(s.getName());
        }
        if (o instanceof CharSymbol) {
            CharSymbol c = (CharSymbol)o;
            return this.getName().compareTo(Character.toString(c.charValue()));
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return this.getName().compareTo(n.value().toString());
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }

    @Override
    public int rangeCompareTo(IEnumerableSymbol s) {
        try {
            return this.compareTo(s);
        }
        catch (IComparableSymbol.NotComparableException e) {
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
    }

    @Override
    public IEnumerableSymbol getMax() {
        return MAX;
    }

    @Override
    public IEnumerableSymbol getTop() {
        return TOP;
    }

    @Override
    public IEnumerableSymbol getMin() {
        return MIN;
    }

    @Override
    public IEnumerableSymbol getBottom() {
        return BOTTOM;
    }

    @Override
    public IEnumerableSymbol getPred() {
        if (this.equals(MIN)) {
            return BOTTOM;
        }
        char[] c = this.getName().toCharArray();
        if (c.length == 0) {
            return BOTTOM;
        }
        int clen = c.length;
        char lastChar = c[clen - 1];
        if (lastChar == '\u0000') {
            String s = new String(c, 0, clen - 1);
            return new StringSymbol(s);
        }
        String s = new String(c, 0, clen - 1);
        lastChar = (char)(lastChar - '\u0001');
        s = s + Character.toString(lastChar);
        return new StringSymbol(s);
    }

    @Override
    public IEnumerableSymbol getSucc() {
        char[] c = this.getName().toCharArray();
        int clen = c.length;
        if (clen == 0) {
            return new StringSymbol("\\0");
        }
        char lastChar = c[clen - 1];
        if (lastChar == '\uffff') {
            String s = new String(c) + Character.toString('\u0000');
            return new StringSymbol(s);
        }
        String s = new String(c, 0, clen - 1);
        lastChar = (char)(lastChar + '\u0001');
        s = s + Character.toString(lastChar);
        return new StringSymbol(s);
    }

    public static abstract class SingularStringSymbol
    extends StringSymbol {
        public SingularStringSymbol() {
            super("");
        }

        @Override
        public abstract IEnumerableSymbol getPred();

        @Override
        public abstract IEnumerableSymbol getSucc();

        @Override
        public StringSymbol stringSymbolValue() {
            return this;
        }

        @Override
        public List<CharSymbol> toCharSymbols() {
            return null;
        }

        @Override
        public String value() {
            return null;
        }

        @Override
        public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
            throw new IComparableSymbol.NotComparableException(this, o);
        }
    }
}

