/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;

public class Symbol
implements ISymbol {
    private String name;

    public Symbol(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        if (name == null) {
            throw new AssertionError((Object)"the symbol name should not be null.");
        }
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            Symbol sym = (Symbol)obj;
            return this.name.equals(sym.name);
        }
        return false;
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (this.equals(symbol)) {
            ctx.put(this, symbol);
            return true;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        return this.matches(symbol, ctx);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof Symbol) {
            Symbol sym = (Symbol)s;
            sym.setName(copier.copyName(sym.name));
        }
        return s;
    }

    @Override
    public int size() {
        return 0;
    }

    public String toString() {
        return "'" + this.getName() + "'";
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

