/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.StateTransitionSystem;
import com.ibm.wala.automaton.tree.CompositeState;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import com.ibm.wala.automaton.tree.ITreeAutomaton;
import com.ibm.wala.automaton.tree.ITreeTransition;
import com.ibm.wala.automaton.tree.StateBinaryTree;
import java.util.HashSet;
import java.util.Set;

public class BottomUpTreeAutomaton
extends StateTransitionSystem
implements ITreeAutomaton {
    private Set<IState> finalStates;

    private static IState createInitialState(ITransition[] transitions) {
        return BottomUpTreeAutomaton.createInitialState(AUtil.set(transitions));
    }

    private static IState createInitialState(Set<ITransition> transitions) {
        HashSet<IState> initStates = new HashSet<IState>();
        for (ITreeTransition iTreeTransition : transitions) {
            final RuntimeException notInitState = new RuntimeException();
            try {
                iTreeTransition.getInputSymbol().traverse(new ISymbolVisitor(){

                    @Override
                    public void onVisit(ISymbol symbol) {
                        if (symbol instanceof IVariable) {
                            throw notInitState;
                        }
                    }

                    @Override
                    public void onLeave(ISymbol symbol) {
                    }
                });
                StateBinaryTree sbt = (StateBinaryTree)iTreeTransition.getOutputSymbols().iterator().next();
                initStates.add(sbt.getState());
            }
            catch (RuntimeException e) {
                if (e == notInitState) continue;
                throw e;
            }
        }
        CompositeState cs = new CompositeState("cs", initStates);
        return cs;
    }

    public BottomUpTreeAutomaton(IState[] finalStates, ITransition[] transitions) {
        super(BottomUpTreeAutomaton.createInitialState(transitions), transitions);
        this.finalStates = AUtil.set(finalStates);
    }

    public BottomUpTreeAutomaton(Set<IState> finalStates, Set<ITransition> transitions) {
        super(BottomUpTreeAutomaton.createInitialState(transitions), transitions);
        this.finalStates = new HashSet<IState>(finalStates);
    }

    public Set<IState> getFinalStates() {
        return this.finalStates;
    }

    private Set<IBinaryTree> translateRec(IBinaryTree tree) {
        if (tree instanceof IParentBinaryTree) {
            IParentBinaryTree ptree = (IParentBinaryTree)tree;
            Set<IBinaryTree> rset = this.translateRec(ptree.getRight());
            Set<IBinaryTree> lset = this.translateRec(ptree.getLeft());
            HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
            for (StateBinaryTree stateBinaryTree : rset) {
                for (StateBinaryTree stateBinaryTree2 : lset) {
                    IParentBinaryTree bt = (IParentBinaryTree)tree.clone();
                    bt.setLeft(stateBinaryTree2);
                    bt.setRight(stateBinaryTree);
                    Set<IBinaryTree> ts = this.translateState(bt);
                    s.addAll(ts);
                }
            }
            return s;
        }
        Set<IBinaryTree> s = this.translateState(tree);
        return s;
    }

    private Set<IBinaryTree> translateState(IBinaryTree tree) {
        HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
        for (ITreeTransition iTreeTransition : this.getTransitions()) {
            MatchContext ctx;
            if (!iTreeTransition.accept(tree, ctx = new MatchContext())) continue;
            IBinaryTree bt = iTreeTransition.transit(tree);
            s.add(bt);
        }
        return s;
    }

    @Override
    public Set<IBinaryTree> translate(IBinaryTree tree) {
        Set<IBinaryTree> trees = this.translateRec(tree);
        HashSet<IBinaryTree> result = new HashSet<IBinaryTree>();
        for (StateBinaryTree stateBinaryTree : trees) {
            if (!this.finalStates.contains(stateBinaryTree.getState())) continue;
            result.add(stateBinaryTree.getTree());
        }
        return result;
    }

    @Override
    public boolean accept(IBinaryTree tree) {
        return !this.translate(tree).isEmpty();
    }
}

