/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.SimpleIntSetIterator;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import java.util.Arrays;

public class TinyOrderdIntSet
implements IntSet {
    public static final TinyOrderdIntSet EMPTY = new TinyOrderdIntSet(new int[0]);
    protected int[] elems;

    public TinyOrderdIntSet(int[] elems) {
        this.elems = new int[elems.length];
        System.arraycopy(elems, 0, this.elems, 0, elems.length);
        Arrays.sort(this.elems);
    }

    public boolean contains(int i) {
        return Arrays.binarySearch(this.elems, i) >= 0;
    }

    public boolean containsAny(IntSet set) {
        IntIterator it = set.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            if (!this.contains(i)) continue;
            return true;
        }
        return false;
    }

    public void foreach(IntSetAction action) {
        for (int i = 0; i < this.elems.length; ++i) {
            action.act(this.elems[i]);
        }
    }

    public void foreachExcluding(IntSet X, IntSetAction action) {
        for (int i = 0; i < this.elems.length; ++i) {
            int e = this.elems[i];
            if (X.contains(e)) continue;
            action.act(e);
        }
    }

    public IntIterator intIterator() {
        return new SimpleIntSetIterator(this);
    }

    public IntSet intersection(IntSet that) {
        int count = 0;
        for (int i = 0; i < this.elems.length; ++i) {
            if (!that.contains(this.elems[i])) continue;
            ++count;
        }
        int[] result = new int[count];
        int j = 0;
        for (int i = 0; i < this.elems.length; ++i) {
            if (!that.contains(this.elems[i])) continue;
            result[j++] = this.elems[i];
        }
        return new TinyOrderdIntSet(result);
    }

    public IntSet union(IntSet that) {
        int count = 0;
        for (int i = 0; i < this.elems.length; ++i) {
            if (that.contains(this.elems[i])) continue;
            ++count;
        }
        int[] result = new int[count + that.size()];
        int j = 0;
        for (int i = 0; i < this.elems.length; ++i) {
            if (!that.contains(this.elems[i])) continue;
            result[j++] = this.elems[i];
        }
        IntIterator x = that.intIterator();
        while (x.hasNext()) {
            result[j++] = x.next();
        }
        return new TinyOrderdIntSet(result);
    }

    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    public boolean isSubset(IntSet that) {
        if (this.size() > that.size()) {
            return false;
        }
        for (int i = 0; i < this.elems.length; ++i) {
            int e = this.elems[i];
            if (that.contains(e)) continue;
            return false;
        }
        return true;
    }

    public int max() {
        return this.elems[this.elems.length - 1];
    }

    public int min() {
        return this.elems[0];
    }

    public boolean sameValue(IntSet that) {
        if (this == that) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        return this.isSubset(that) && that.isSubset((IntSet)this);
    }

    public int size() {
        return this.elems.length;
    }
}

