/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.labeledgraph;

import com.ibm.wala.automaton.util.labeledgraph.DelegatingMutableEdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.EdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.IRegexAlgebra;
import com.ibm.wala.automaton.util.labeledgraph.IRegexFactory;
import com.ibm.wala.automaton.util.labeledgraph.StandardizedGraph;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2List;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.labeled.LabeledGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LabelReduction {
    public static <T, U, L> U reduceLabels(final LabeledGraph<T, L> graph, final Collection<T> entries, final Collection<T> exits, final T pseudoInitial, final T pseudoFinal, final IRegexFactory<U, L> labelop) {
        EdgeDecorator labels = new EdgeDecorator<T, U>(){

            @Override
            public U getLabel(T src, T dest) {
                if (src.equals(pseudoInitial) && entries.contains(dest)) {
                    return labelop.makeEmpty();
                }
                if (exits.contains(src) && dest.equals(pseudoFinal)) {
                    return labelop.makeEmpty();
                }
                Object label = null;
                for (Object l : graph.getEdgeLabels(src, dest)) {
                    if (label == null) {
                        label = labelop.makeSymbol(l);
                        continue;
                    }
                    label = labelop.union(label, labelop.makeSymbol(l));
                }
                return label;
            }
        };
        return LabelReduction.reduceLabels(graph, labels, entries.iterator(), exits.iterator(), pseudoInitial, pseudoFinal, labelop, Collections.emptySet());
    }

    public static <T, U, V extends T> U reduceLabels(Graph<V> graph, EdgeDecorator<T, U> labels, Iterator<? extends V> entries, Iterator<? extends V> exits, T pseudoInitial, T pseudoFinal, IRegexAlgebra<U> labelop) {
        return LabelReduction.reduceLabels(graph, labels, entries, exits, pseudoInitial, pseudoFinal, labelop, Collections.emptySet());
    }

    public static <T, U, V extends T> U reduceLabels(Graph<V> graph, EdgeDecorator<T, U> labels, Iterator<? extends V> entries, Iterator<? extends V> exits, T pseudoInitial, T pseudoFinal, IRegexAlgebra<U> labelop, Collection<Pair<T, T>> ignoredEdges) {
        StandardizedGraph<? extends V, V> g = new StandardizedGraph<V, V>(graph, entries, exits, pseudoInitial, pseudoFinal);
        DelegatingMutableEdgeDecorator<Object, U> mem = new DelegatingMutableEdgeDecorator<Object, U>(labels);
        for (Pair<T, T> edge : ignoredEdges) {
            g.removeEdge(edge.fst, edge.snd);
            mem.removeLabel(edge.fst, edge.snd);
        }
        Iterator it = graph.iterator();
        ArrayList nodes = new ArrayList(graph.getNumberOfNodes());
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        Object ret = null;
        Collections.sort(nodes, new NodeSorter<V>(graph));
        for (Object n : nodes) {
            Object kleene = null;
            if (g.hasEdge(n, n)) {
                kleene = labelop.kleene(mem.getLabel(n, n));
                g.removeEdge(n, n);
            }
            Iterator2List preds = Iterator2Collection.toList((Iterator)g.getPredNodes(n));
            Iterator2List succs = Iterator2Collection.toList((Iterator)g.getSuccNodes(n));
            for (Object p : preds) {
                U l1 = mem.getLabel(p, n);
                g.removeEdge(p, n);
                for (Object s : succs) {
                    U l2 = mem.getLabel(n, s);
                    Object newlab = null;
                    newlab = kleene != null ? labelop.concat(l1, kleene) : (Object)l1;
                    newlab = labelop.concat(newlab, l2);
                    g.removeEdge(n, s);
                    g.addEdge(p, s);
                    U oldlabel = mem.getLabel(p, s);
                    if (oldlabel != null) {
                        newlab = labelop.union(oldlabel, newlab);
                    }
                    mem.addLabel(p, newlab, s);
                    if (p != pseudoInitial || s != pseudoFinal) continue;
                    ret = newlab;
                }
            }
        }
        return ret;
    }

    private static class NodeSorter<T>
    implements Comparator<T> {
        private Map<T, Pair<Integer, Integer>> cacheOfPredAndSuccCount = new HashMap<T, Pair<Integer, Integer>>();
        private final Graph<T> graph;

        @Override
        public int compare(T arg1, T arg2) {
            Pair res = this.cacheOfPredAndSuccCount.get(arg1);
            if (res == null) {
                res = Pair.make((Object)this.graph.getPredNodeCount(arg1), (Object)this.graph.getSuccNodeCount(arg1));
                this.cacheOfPredAndSuccCount.put(arg1, (Pair<Integer, Integer>)res);
            }
            int x1 = (Integer)res.fst;
            int y1 = (Integer)res.snd;
            Pair res2 = this.cacheOfPredAndSuccCount.get(arg2);
            if (res2 == null) {
                res2 = Pair.make((Object)this.graph.getPredNodeCount(arg2), (Object)this.graph.getSuccNodeCount(arg2));
                this.cacheOfPredAndSuccCount.put(arg2, (Pair<Integer, Integer>)res2);
            }
            int x2 = (Integer)res2.fst;
            int y2 = (Integer)res2.snd;
            Integer n1 = x1 * y1;
            Integer n2 = x2 * y2;
            return n1.compareTo(n2);
        }

        public NodeSorter(Graph<T> g) {
            this.graph = g;
        }
    }
}

