/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JAXApp;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;

public class JAXUtils {
    public static final String PATH_ANNOTATION = "Ljavax/ws/rs/Path";
    public static final String GET_ANNOTATION = "Ljavax/ws/rs/GET";
    public static final String POST_ANNOTATION = "Ljavax/ws/rs/POST";
    public static final String PUT_ANNOTATION = "Ljavax/ws/rs/PUT";
    public static final String DELETE_ANNOTATION = "Ljavax/ws/rs/DELETE";
    public static final String APPLICATION_PATH_ANNOTATION = "Ljavax/ws/rs/ApplicationPath";
    public static final String PROVIDER_ANNOTATION = "Ljavax/ws/rs/ext/Provider";
    public static final String APPLICATION_QN = "javax.ws.rs.Application";
    public static final String MESSAGEBODYREADER_INTERFACE = "Ljavax/ws/rs/ext/MessageBodyReader";
    public static final String MESSAGEBODYWRITTER_INTERFACE = "Ljavax/ws/rs/ext/MessageBodyWriter";
    public static final String EXCEPTION_MAPPER_INTERFACE = "Ljavax/ws/rs/ext/ExceptionMapper";
    public static final String CONTEXT_RESOLVER_INTERFACE = "Ljavax/ws/rs/ext/ContextResolver";
    public static final String CONTEXT_ANNOTATION = "Ljavax/ws/rs/core/Context";
    public static final String PATH_ANNOTATION_QN = "javax.ws.rs.Path";

    private JAXUtils() {
    }

    public static Boolean hasAnnotation(F4FApp app, Object element, String annotationQN) {
        Collection elementAnnotations = null;
        if (element instanceof IClass) {
            elementAnnotations = app.getClassAnnotations((IClass)element);
        } else if (element instanceof IMethod) {
            elementAnnotations = app.getMethodAnnotations((IMethod)element);
        } else if (element instanceof IField) {
            elementAnnotations = app.getFieldAnnotations((IField)element);
        }
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(annotationQN)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getJavaName(String s) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            sb.append("_");
        }
        for (char c : s.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Annotation getAnnotation(F4FApp app, Object element, String annotationQN) {
        Collection elementAnnotations = null;
        if (element instanceof IClass) {
            elementAnnotations = app.getClassAnnotations((IClass)element);
        } else if (element instanceof IMethod) {
            elementAnnotations = app.getMethodAnnotations((IMethod)element);
        }
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(annotationQN)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static boolean isJAXRSRestAPI(F4FApp app, IMethod method) {
        if (JAXUtils.hasAnnotation(app, method, PATH_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, GET_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, PUT_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, POST_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, DELETE_ANNOTATION).booleanValue()) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/ws/rs/Path || Ljavax/ws/rs/GET || Ljavax/ws/rs/PUT || Ljavax/ws/rs/POST || Ljavax/ws/rs/DELETE"}));
            return true;
        }
        return false;
    }

    public static boolean isSubResourceLocator(F4FApp app, IMethod method) {
        TypeReference returnType = method.getReturnType();
        if (returnType.isPrimitiveType()) {
            return false;
        }
        if (!(!JAXUtils.hasAnnotation(app, method, PATH_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, GET_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, PUT_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, POST_ANNOTATION).booleanValue() || JAXUtils.hasAnnotation(app, method, DELETE_ANNOTATION).booleanValue())) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{PATH_ANNOTATION}));
            return true;
        }
        return false;
    }

    public static ArrayList<IMethod> getJAXRSHttpMethods(F4FApp app, IClass clazz) {
        ArrayList<IMethod> httpMethods = new ArrayList<IMethod>();
        if (clazz != null) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{clazz.getName().toString()}));
            for (IMethod method : clazz.getDeclaredMethods()) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{method.getSignature()}));
                if (!JAXUtils.isJAXRSRestAPI(app, method)) continue;
                httpMethods.add(method);
            }
        }
        return httpMethods;
    }

    public static String convertToJavaName(String className) {
        String javaClassName = className.replaceAll("\\.", "/");
        return "L" + javaClassName;
    }

    public static String convertToSimpleName(String className) {
        String javaClassName = className.replaceAll("\\/", ".");
        if ((javaClassName = javaClassName.substring(1)).endsWith(";")) {
            javaClassName = javaClassName.substring(0, javaClassName.length() - 1);
        }
        return javaClassName;
    }

    public static Boolean doesExtendClass(IClass clazz, String superClassName) {
        IClass superClass = clazz.getSuperclass();
        if (superClass != null) {
            if (superClass.getName().toString().equals(superClassName)) {
                return true;
            }
            return JAXUtils.doesExtendClass(superClass, superClassName);
        }
        return false;
    }

    public static JAXApp constructJAXApp(F4FApp app) {
        JAXApp jaxApp = new JAXApp();
        jaxApp.constructApp(app);
        return jaxApp;
    }

    public static IClass findInderface(IClass clazz, String interfaceName) {
        for (IClass interf : clazz.getAllImplementedInterfaces()) {
            if (!interf.getName().toString().equals(interfaceName)) continue;
            return interf;
        }
        return null;
    }
}

