/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.PPFInfo;
import com.ibm.appscan.frameworks.util.PreNamespaceContext;
import com.ibm.appscan.frameworks.util.SchemaUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FrameworksInput {
    private static final String NAMESPACE_URI = "http://www.ibm.com/FrameworkInput";
    private final FileLocations fileLocs;
    private final Properties options;
    private final String type;
    private final PPFInfo projectFileInfo;

    public static FrameworksInput make(String inputFilename) throws XPathExpressionException {
        return new FrameworksInput(inputFilename);
    }

    public static FrameworksInput make(FileLocations fileLocs, Properties options, String type, PPFInfo ppfInfo) {
        return new FrameworksInput(fileLocs, options, type, ppfInfo);
    }

    private FrameworksInput(String inputFilename) throws XPathExpressionException {
        Document doc = this.parseInputFile(inputFilename);
        this.fileLocs = this.parseFileLocs(doc);
        this.options = this.getOptions(doc);
        this.type = this.getType(doc);
        this.projectFileInfo = PPFInfo.make(this.fileLocs.getProjectFile());
    }

    private FrameworksInput(FileLocations fileLocs, Properties options, String type, PPFInfo ppfInfo) {
        this.fileLocs = fileLocs;
        this.options = options;
        this.type = type;
        this.projectFileInfo = ppfInfo;
    }

    private String getType(Document doc) throws XPathExpressionException {
        XPath xpath = this.createXPath();
        XPathExpression propertyExpr = xpath.compile("//pre:FrameworkInput");
        Node frameworkInputNode = (Node)propertyExpr.evaluate(doc, XPathConstants.NODE);
        return frameworkInputNode.getAttributes().getNamedItem("type").getTextContent();
    }

    private Properties getOptions(Document doc) throws XPathExpressionException {
        XPath xpath = this.createXPath();
        Properties result = new Properties();
        XPathExpression propertyExpr = xpath.compile("//pre:Property");
        Object props = propertyExpr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)props;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node prop = nodes.item(i);
            NamedNodeMap attributes = prop.getAttributes();
            String key = attributes.getNamedItem("name").getTextContent();
            String value = attributes.getNamedItem("value").getTextContent();
            result.setProperty(key, value);
        }
        return result;
    }

    private FileLocations parseFileLocs(Document doc) throws XPathExpressionException {
        XPath xpath = this.createXPath();
        String scopeFileName = xpath.compile("normalize-space(//pre:WalaScopeFile/text())").evaluate(doc);
        assert (scopeFileName != null);
        String webContentDir = xpath.compile("normalize-space(//pre:WebContentRoot/text())").evaluate(doc);
        assert (webContentDir != null);
        String outputWAFLFileName = xpath.compile("normalize-space(//pre:WaflFile/text())").evaluate(doc);
        assert (outputWAFLFileName != null);
        String logFileName = xpath.compile("normalize-space(//pre:LogConfig/text())").evaluate(doc);
        assert (logFileName != null);
        String projectFile = xpath.compile("normalize-space(//pre:ProjectFile/text())").evaluate(doc);
        String handlerJarDir = xpath.compile("normalize-space(//pre:HandlerJarDir/text())").evaluate(doc);
        String exclusionsFileName = xpath.compile("normalize-space(pre:WalaExclusionsFile/text())").evaluate(doc);
        if (exclusionsFileName.equals("")) {
            exclusionsFileName = null;
        }
        String workspace = System.getProperty("WorkSpace");
        String taintResources = System.getProperty("TaintResources");
        if (workspace != null && taintResources != null) {
            scopeFileName = scopeFileName.replace("${WorkSpace)", workspace).replace("${R_DRIVE)", taintResources);
            webContentDir = webContentDir.replace("${WorkSpace)", workspace).replace("${R_DRIVE)", taintResources);
            outputWAFLFileName = outputWAFLFileName.replace("${WorkSpace)", workspace).replace("${R_DRIVE)", taintResources);
            logFileName = logFileName.replace("${WorkSpace)", workspace).replace("${R_DRIVE)", taintResources);
            if (exclusionsFileName != null) {
                exclusionsFileName = exclusionsFileName.replace("${WorkSpace)", workspace).replace("${R_DRIVE)", taintResources);
            }
        }
        return new FileLocations(scopeFileName, exclusionsFileName, webContentDir, outputWAFLFileName, logFileName, projectFile, handlerJarDir);
    }

    private XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new PreNamespaceContext(NAMESPACE_URI));
        return xpath;
    }

    private Document parseInputFile(String inputFilename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(inputFilename));
        }
        catch (ParserConfigurationException e) {
            System.exit(2);
        }
        catch (SAXException e) {
            System.exit(2);
        }
        catch (IOException e) {
            System.exit(2);
        }
        URL inputSchemaFile = this.getClass().getClassLoader().getResource("FrameworkInput.xsd");
        try {
            SchemaUtils.validateDocumentAgainstSchema(doc, inputSchemaFile);
        }
        catch (SAXException e) {
            System.exit(3);
        }
        catch (IOException e) {
            System.exit(3);
        }
        return doc;
    }

    public FileLocations getFileLocs() {
        return this.fileLocs;
    }

    public Properties getOptions() {
        return this.options;
    }

    public String getType() {
        return this.type;
    }

    public PPFInfo getProjectFileInfo() {
        return this.projectFileInfo;
    }
}

