/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.scanner.config;

import com.ibm.appscan.scanner.config.ConfigurationInfo;
import com.ibm.appscan.scanner.config.ScanConfigException;
import com.ibm.appscan.scanner.config.SourceFile;
import com.ibm.appscan.scanner.config.data.ScanConfigReader;
import com.ibm.appscan.scanner.config.data.ScanConfigWriter;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.util.ArrayList;

public class ScanConfiguration {
    private ArrayList<SourceFile> m_files;
    private ConfigurationInfo m_config_info;

    public ScanConfiguration() {
    }

    public ScanConfiguration(File f) throws ScanConfigException {
        ScanConfigReader r = new ScanConfigReader(f);
        for (SourceFile sf : r.getScanConfiguration().getSourceFiles()) {
            this.addSourceFile(sf);
        }
        this.addConfigInfo(r.getScanConfiguration().getConfigInfo());
    }

    public void save(File f) throws ScanConfigException {
        ScanConfigWriter w = new ScanConfigWriter(f);
        w.save(this);
    }

    public ArrayList<SourceFile> getSourceFiles() {
        if (this.m_files == null) {
            this.m_files = new ArrayList();
        }
        return this.m_files;
    }

    public ConfigurationInfo getConfigInfo() {
        return this.m_config_info;
    }

    @SuppressSecurityTrace
    public void addSourceFile(SourceFile sf) {
        this.getSourceFiles().add(sf);
    }

    @SuppressSecurityTrace
    public void addConfigInfo(ConfigurationInfo ci) {
        this.m_config_info = new ConfigurationInfo(ci.getScanOutputFilePath());
    }
}

