/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.scanner.config.data;

import com.ibm.appscan.common.xml.XMLStreamReader;
import com.ibm.appscan.scanner.config.ConfigurationInfo;
import com.ibm.appscan.scanner.config.ScanConfigEnum;
import com.ibm.appscan.scanner.config.ScanConfigException;
import com.ibm.appscan.scanner.config.ScanConfiguration;
import com.ibm.appscan.scanner.config.SourceFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class ScanConfigReader
extends XMLStreamReader {
    private InputStream m_input_stream;
    private ScanConfiguration m_scanconfig;

    public ScanConfigReader(File f) throws ScanConfigException {
        try {
            this.m_input_stream = new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new ScanConfigException(e);
        }
    }

    public ScanConfiguration getScanConfiguration() throws ScanConfigException {
        if (this.m_scanconfig == null) {
            this.m_scanconfig = new ScanConfiguration();
            try {
                this.read(this.m_input_stream);
            }
            catch (XMLStreamException e) {
                throw new ScanConfigException(e);
            }
        }
        return this.m_scanconfig;
    }

    protected boolean process(StartElement element) {
        if (element.getName().getLocalPart().equals(ScanConfigEnum.SOURCE_FILE_E)) {
            String src_path = this.getAttribute(element, ScanConfigEnum.SRC_PATH_A);
            if (src_path != null) {
                this.m_scanconfig.addSourceFile(new SourceFile(this.getAttribute(element, ScanConfigEnum.PATH_A), src_path));
            } else {
                this.m_scanconfig.addSourceFile(new SourceFile(this.getAttribute(element, ScanConfigEnum.PATH_A)));
            }
        } else if (element.getName().getLocalPart().equals(ScanConfigEnum.CONFIGURATION_INFO_E)) {
            this.m_scanconfig.addConfigInfo(new ConfigurationInfo(this.getAttribute(element, ScanConfigEnum.SCAN_OUTPUT_FILE_PATH_A)));
        }
        return super.process(element);
    }
}

