/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.scanner.config.data;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.scanner.config.ScanConfigEnum;
import com.ibm.appscan.scanner.config.ScanConfigException;
import com.ibm.appscan.scanner.config.ScanConfiguration;
import com.ibm.appscan.scanner.config.SourceFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class ScanConfigWriter {
    private DOMWriter m_writer;
    private DocumentBuilder m_builder;
    private Transformer m_transformer;
    private OutputStream m_stream;

    public ScanConfigWriter(File f) throws ScanConfigException {
        try {
            this.m_stream = new BufferedOutputStream(new FileOutputStream(f));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.m_builder = factory.newDocumentBuilder();
                TransformerFactory transform_factory = TransformerFactory.newInstance();
                this.m_transformer = transform_factory.newTransformer();
                this.m_transformer.setOutputProperty("indent", "yes");
                this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                this.m_transformer.setOutputProperty("standalone", "yes");
                this.m_writer = new DOMWriter(this.m_stream, this.m_builder);
            }
            catch (ParserConfigurationException e) {
                throw new ScanConfigException(e);
            }
            catch (TransformerConfigurationException e) {
                throw new ScanConfigException(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new ScanConfigException(e);
        }
    }

    public void save(ScanConfiguration sc) throws ScanConfigException {
        try {
            this.m_writer.beginElement(ScanConfigEnum.SCAN_CONFIGURATION_E);
            this.m_writer.beginElement(ScanConfigEnum.CONFIGURATION_INFO_E);
            this.m_writer.setAttribute(ScanConfigEnum.CONFIGURATION_NAME_A, "Configuration 1");
            this.m_writer.setAttribute(ScanConfigEnum.SCAN_OUTPUT_FILE_PATH_A, sc.getConfigInfo().getScanOutputFilePath());
            this.m_writer.setAttribute(ScanConfigEnum.PROJECT_FILE_PATH_A, sc.getConfigInfo().getScanOutputPath() + File.separator + "rr.ppf");
            this.m_writer.setAttribute(ScanConfigEnum.SCAN_CANCEL_FILE_PATH_A, sc.getConfigInfo().getScanOutputPath() + File.separator + "ounce_cancel");
            this.m_writer.setAttribute(ScanConfigEnum.SCAN_STOP_FILE_PATH_A, sc.getConfigInfo().getScanOutputPath() + File.separator + "ounce_stop");
            this.m_writer.endElement();
            this.m_writer.beginElement(ScanConfigEnum.CONFIGURATION_E);
            this.m_writer.setAttribute(ScanConfigEnum.NAME_A, "Configuration 1");
            this.m_writer.endElement();
            this.m_writer.beginElement(ScanConfigEnum.SOURCE_FILES_E);
            for (SourceFile sf : sc.getSourceFiles()) {
                this.m_writer.beginElement(ScanConfigEnum.SOURCE_FILE_E);
                this.m_writer.setAttribute(ScanConfigEnum.PATH_A, sf.getPath());
                this.m_writer.setAttribute(ScanConfigEnum.SRC_PATH_A, sf.getSrcPath());
                this.m_writer.endElement();
            }
            this.m_writer.endElement();
            this.m_writer.endElement();
            this.m_writer.write(this.m_transformer);
        }
        catch (TransformerException e) {
            throw new ScanConfigException(e);
        }
        finally {
            IOUtil.close((Closeable)this.m_stream);
        }
    }
}

