/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;

public class JSPFileParser {
    private String jsfFileName;
    private BufferedReader jsfFileBufferedReader;
    private StringBuilder currProcessJsfNode;
    private StringBuilder jsfNodesStr = new StringBuilder();
    private String lineSeparator = System.getProperty("line.separator");

    public JSPFileParser(String jsfFileName) {
        this.jsfFileName = jsfFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void parse() {
        block27: {
            String currContent;
            block26: {
                File jspFile;
                block25: {
                    jspFile = new File(this.jsfFileName);
                    if (jspFile.exists() && jspFile.isFile()) break block25;
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{this.jsfFileName}));
                    try {
                        if (this.jsfFileBufferedReader != null) {
                            this.jsfFileBufferedReader.close();
                        }
                    }
                    catch (IOException e) {
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                    }
                    return;
                }
                this.jsfFileBufferedReader = new BufferedReader(new FileReader(jspFile));
                currContent = this.readNewContent();
                if (currContent != null) break block26;
                try {
                    if (this.jsfFileBufferedReader != null) {
                        this.jsfFileBufferedReader.close();
                    }
                }
                catch (IOException e) {
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                }
                return;
            }
            this.currProcessJsfNode = new StringBuilder();
            while (currContent != null) {
                int startIndex = currContent.indexOf("<h:");
                if (startIndex >= 0) {
                    try {
                        currContent = this.identifyJSFNodes(currContent.substring(startIndex));
                    }
                    catch (Exception e) {
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                        this.currProcessJsfNode = new StringBuilder();
                        currContent = this.readNewContent();
                        continue;
                    }
                    if (currContent == null) continue;
                    this.jsfNodesStr.append(this.currProcessJsfNode.toString());
                    this.currProcessJsfNode = new StringBuilder();
                    continue;
                }
                this.jsfNodesStr.append(this.getLineSeperators(currContent));
                currContent = this.readNewContent();
            }
            this.jsfFileBufferedReader.close();
            try {
                if (this.jsfFileBufferedReader != null) {
                    this.jsfFileBufferedReader.close();
                }
                break block27;
            }
            catch (IOException e) {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            }
            break block27;
            catch (Exception e) {
                try {
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                }
                catch (Throwable throwable) {
                    try {
                        if (this.jsfFileBufferedReader != null) {
                            this.jsfFileBufferedReader.close();
                        }
                    }
                    catch (IOException e2) {
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e2.toString() + Messages.getTraceFromException((Exception)e2)}));
                    }
                    throw throwable;
                }
                try {
                    if (this.jsfFileBufferedReader != null) {
                        this.jsfFileBufferedReader.close();
                    }
                }
                catch (IOException e3) {
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                    TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e3.toString() + Messages.getTraceFromException((Exception)e3)}));
                }
            }
        }
    }

    private String readNewContent() throws IOException {
        int length;
        String newContent = null;
        do {
            String newLine;
            if ((newLine = this.jsfFileBufferedReader.readLine()) == null) {
                return newContent;
            }
            if (newContent == null) {
                newContent = newLine + this.lineSeparator;
                length = newContent.length();
                continue;
            }
            newContent = newContent + newLine + this.lineSeparator;
            length = newContent.length();
            if (!newContent.contains("<![CDATA[")) continue;
            newContent = this.removeCDATA(newContent);
            length = newContent.length();
        } while (length < 4);
        return newContent;
    }

    private String removeCDATA(String content) throws IOException {
        int startIndex = content.indexOf("<![CDATA[");
        if (startIndex < 0) {
            return content;
        }
        String retString = null;
        while (true) {
            int endIndex;
            if ((endIndex = content.indexOf("]]>")) >= 0) {
                retString = content.substring(0, startIndex) + this.getLineSeperators(content.substring(startIndex, endIndex + 3)) + content.substring(endIndex + 3);
                if (!retString.contains("<![CDATA[")) {
                    return retString;
                }
                return this.removeCDATA(retString);
            }
            String newContent = this.readNewContent();
            if (newContent == null) {
                return "";
            }
            content = content + newContent;
        }
    }

    private String identifyJSFNodes(String content) throws IOException {
        Stack<Character> specialCharStack = new Stack<Character>();
        boolean isJSFNode = true;
        if (!content.toString().startsWith("<h:")) {
            isJSFNode = false;
        }
        if (isJSFNode) {
            this.currProcessJsfNode.append(content.substring(0, 3));
            content = content.substring(3);
        } else if (content.startsWith("<")) {
            content = content.substring(1);
        } else {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
            return null;
        }
        int contentIndex = 0;
        if (content.length() < 4) {
            String newContent = this.readNewContent();
            if (newContent == null) {
                return null;
            }
            content = content + newContent;
        }
        int length = content.length();
        while (contentIndex + 3 < length) {
            String newContent;
            char ch = content.charAt(contentIndex);
            boolean isEscape = false;
            if (ch == '\"' || ch == '\'') {
                if (contentIndex > 0 && content.charAt(contentIndex - 1) == '\\' && !specialCharStack.isEmpty()) {
                    isEscape = true;
                }
                if (specialCharStack.isEmpty() && !isEscape) {
                    specialCharStack.push(new Character(ch));
                } else if (((Character)specialCharStack.peek()).charValue() == ch && !isEscape) {
                    specialCharStack.pop();
                } else if (!isEscape) {
                    specialCharStack.push(new Character(ch));
                }
            }
            if (!specialCharStack.isEmpty()) {
                if (ch == '<') {
                    content = content.substring(0, contentIndex) + "&lt;" + content.substring(contentIndex + 1);
                    contentIndex += 3;
                }
                if (ch == '>') {
                    content = content.substring(0, contentIndex) + "&gt;" + content.substring(contentIndex + 1);
                    contentIndex += 3;
                }
                if (ch == '&') {
                    content = content.substring(0, contentIndex) + "&amp;" + content.substring(contentIndex + 1);
                    contentIndex += 4;
                }
                ++contentIndex;
            } else {
                String lineSeparators;
                if (ch == '/' && content.charAt(contentIndex + 1) == '>' && isJSFNode) {
                    this.currProcessJsfNode.append(content.substring(0, contentIndex + 2));
                    return content.substring(contentIndex + 2);
                }
                if (ch == '>' && !isJSFNode) {
                    lineSeparators = this.getLineSeperators(content.substring(0, contentIndex + 1));
                    return lineSeparators + content.substring(contentIndex + 1);
                }
                if (ch == '>' && isJSFNode) {
                    this.currProcessJsfNode.append(content.substring(0, contentIndex + 1));
                    content = content.substring(contentIndex + 1);
                    length = content.length();
                    contentIndex = 0;
                } else if (ch == '<' && content.charAt(contentIndex + 1) == 'h' && content.charAt(contentIndex + 2) == ':') {
                    if (!isJSFNode) {
                        lineSeparators = this.getLineSeperators(content.substring(0, contentIndex));
                        content = lineSeparators + content.substring(contentIndex);
                        length = content.length();
                        contentIndex = lineSeparators.length();
                    } else {
                        this.currProcessJsfNode.append(content.substring(0, contentIndex));
                    }
                    content = this.identifyJSFNodes(content.substring(contentIndex));
                    if (content == null) {
                        return null;
                    }
                    contentIndex = 0;
                    length = content.length();
                } else {
                    if (ch == '<' && content.charAt(contentIndex + 1) == '/' && content.charAt(contentIndex + 2) == 'h' && content.charAt(contentIndex + 3) == ':' && isJSFNode) {
                        int endTagIndex = content.indexOf(">");
                        while (endTagIndex < 0) {
                            String str = this.readNewContent();
                            if (str == null) {
                                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.jsfFileName}));
                                this.currProcessJsfNode.replace(0, this.currProcessJsfNode.length(), this.getLineSeperators(this.currProcessJsfNode.toString()));
                                return null;
                            }
                            content = content + this.readNewContent();
                            endTagIndex = content.indexOf(">");
                        }
                        this.currProcessJsfNode.append(content.substring(0, endTagIndex + 1));
                        return content.substring(endTagIndex + 1);
                    }
                    if (ch == '<' && (content.charAt(contentIndex + 1) != 'h' || content.charAt(contentIndex + 2) != ':') && specialCharStack.isEmpty()) {
                        if (isJSFNode) {
                            this.currProcessJsfNode.append(content.substring(0, contentIndex));
                        }
                        if ((content = this.identifyJSFNodes(content.substring(contentIndex))) == null) {
                            return null;
                        }
                        length = content.length();
                        contentIndex = 0;
                    } else {
                        ++contentIndex;
                    }
                }
            }
            if (contentIndex < length - 3 || (newContent = this.readNewContent()) == null) continue;
            content = content + newContent;
            length = content.length();
        }
        return null;
    }

    private String getLineSeperators(String str) {
        int index = str.indexOf(this.lineSeparator);
        StringBuilder allLineSeperators = new StringBuilder();
        while (index >= 0) {
            allLineSeperators.append(this.lineSeparator);
            index = str.indexOf(this.lineSeparator, index + 1);
        }
        return allLineSeperators.toString();
    }

    public String getExtractedJSFContent() {
        return this.jsfNodesStr.toString();
    }

    public static void main(String[] args) {
        JSPFileParser jspParser = new JSPFileParser("C:\\TestApps\\F4F Apps\\JSF\\JCatalog\\JCatalog_staging\\editProduct.jsp");
        jspParser.parse();
        System.out.println("-----JSF Node:---------");
        System.out.println(jspParser.getExtractedJSFContent());
    }
}

