/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.AstJavaNewEnclosingInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class JavaCAst2IRTranslator
extends AstTranslator {
    private final CAstEntity fSourceEntity;
    private final ModuleEntry module;

    public JavaCAst2IRTranslator(ModuleEntry module, CAstEntity sourceFileEntity, JavaSourceLoaderImpl loader) {
        super((IClassLoader)loader);
        this.fSourceEntity = sourceFileEntity;
        this.module = module;
    }

    public void translate() {
        this.translate(this.fSourceEntity, this.module);
    }

    public CAstEntity sourceFileEntity() {
        return this.fSourceEntity;
    }

    public JavaSourceLoaderImpl loader() {
        return (JavaSourceLoaderImpl)this.loader;
    }

    protected boolean useDefaultInitValues() {
        return true;
    }

    protected boolean hasImplicitGlobals() {
        return false;
    }

    protected TypeReference defaultCatchType() {
        return TypeReference.JavaLangThrowable;
    }

    protected TypeReference makeType(CAstType type) {
        return TypeReference.findOrCreate((ClassLoaderReference)this.loader.getReference(), (TypeName)TypeName.string2TypeName((String)type.getName()));
    }

    protected boolean treatGlobalsAsLexicallyScoped() {
        Assertions.UNREACHABLE();
        return false;
    }

    protected void doThrow(AstTranslator.WalkContext context, int exception) {
        context.cfg().addInstruction((SSAInstruction)this.insts.ThrowInstruction(context.cfg().getCurrentInstruction(), exception));
    }

    public void doArrayRead(AstTranslator.WalkContext context, int result, int arrayValue, CAstNode arrayRefNode, int[] dimValues) {
        TypeReference arrayTypeRef = (TypeReference)arrayRefNode.getChild(1).getValue();
        context.cfg().addInstruction((SSAInstruction)this.insts.ArrayLoadInstruction(context.cfg().getCurrentInstruction(), result, arrayValue, dimValues[0], arrayTypeRef));
        this.processExceptions(arrayRefNode, context);
    }

    public void doArrayWrite(AstTranslator.WalkContext context, int arrayValue, CAstNode arrayRefNode, int[] dimValues, int rval) {
        TypeReference arrayTypeRef = arrayRefNode.getKind() == 117 ? ((TypeReference)arrayRefNode.getChild(0).getChild(0).getValue()).getArrayElementType() : (TypeReference)arrayRefNode.getChild(1).getValue();
        context.cfg().addInstruction((SSAInstruction)this.insts.ArrayStoreInstruction(context.cfg().getCurrentInstruction(), arrayValue, dimValues[0], rval, arrayTypeRef));
        this.processExceptions(arrayRefNode, context);
    }

    protected void doFieldRead(AstTranslator.WalkContext context, int result, int receiver, CAstNode elt, CAstNode parent) {
        FieldReference fieldRef = (FieldReference)elt.getValue();
        if (receiver == -1) {
            context.cfg().addInstruction((SSAInstruction)this.insts.GetInstruction(context.cfg().getCurrentInstruction(), result, fieldRef));
        } else {
            context.cfg().addInstruction((SSAInstruction)this.insts.GetInstruction(context.cfg().getCurrentInstruction(), result, receiver, fieldRef));
            this.processExceptions(parent, context);
        }
    }

    protected void doFieldWrite(AstTranslator.WalkContext context, int receiver, CAstNode elt, CAstNode parent, int rval) {
        FieldReference fieldRef = (FieldReference)elt.getValue();
        if (receiver == -1) {
            context.cfg().addInstruction((SSAInstruction)this.insts.PutInstruction(context.cfg().getCurrentInstruction(), rval, fieldRef));
        } else {
            context.cfg().addInstruction((SSAInstruction)this.insts.PutInstruction(context.cfg().getCurrentInstruction(), receiver, rval, fieldRef));
            this.processExceptions(parent, context);
        }
    }

    protected void doMaterializeFunction(CAstNode n, AstTranslator.WalkContext context, int result, int exception, CAstEntity fn) {
        Assertions.UNREACHABLE((String)"Real functions in Java??? I don't think so!");
    }

    protected void doNewObject(AstTranslator.WalkContext context, CAstNode newNode, int result, Object type, int[] arguments) {
        TypeReference typeRef = (TypeReference)type;
        NewSiteReference site = NewSiteReference.make((int)context.cfg().getCurrentInstruction(), (TypeReference)typeRef);
        if (newNode.getKind() == 130) {
            context.cfg().addInstruction((SSAInstruction)new AstJavaNewEnclosingInstruction(context.cfg().getCurrentInstruction(), result, site, arguments[0]));
        } else {
            context.cfg().addInstruction((SSAInstruction)(arguments == null ? this.insts.NewInstruction(context.cfg().getCurrentInstruction(), result, site) : this.insts.NewInstruction(context.cfg().getCurrentInstruction(), result, site, arguments)));
        }
        this.processExceptions(newNode, context);
    }

    private void processExceptions(CAstNode n, AstTranslator.WalkContext context) {
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(true);
        Collection labels = context.getControlFlow().getTargetLabels(n);
        for (Object label : labels) {
            CAstNode target = context.getControlFlow().getTarget(n, label);
            if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                context.cfg().addPreEdgeToExit(n, true);
                continue;
            }
            context.cfg().addPreEdge(n, target, true);
        }
    }

    protected void doCall(AstTranslator.WalkContext context, CAstNode call, int result, int exception, CAstNode name, int receiver, int[] arguments) {
        CallSiteReference realSiteRef;
        int[] realArgs;
        assert (name.getKind() == 300);
        CallSiteReference dummySiteRef = (CallSiteReference)name.getValue();
        int pc = context.cfg().getCurrentInstruction();
        boolean isStatic = receiver == -1;
        int[] nArray = realArgs = isStatic ? arguments : new int[arguments.length + 1];
        if (!isStatic) {
            realArgs[0] = receiver;
            System.arraycopy(arguments, 0, realArgs, 1, arguments.length);
        }
        if ((realSiteRef = CallSiteReference.make((int)pc, (MethodReference)dummySiteRef.getDeclaredTarget(), (IInvokeInstruction.IDispatch)dummySiteRef.getInvocationCode())).getDeclaredTarget().getReturnType().equals((Object)TypeReference.Void)) {
            context.cfg().addInstruction((SSAInstruction)new AstJavaInvokeInstruction(context.cfg().getCurrentInstruction(), realArgs, exception, realSiteRef));
        } else {
            context.cfg().addInstruction((SSAInstruction)new AstJavaInvokeInstruction(context.cfg().getCurrentInstruction(), result, realArgs, exception, realSiteRef));
        }
        this.processExceptions(call, context);
    }

    protected void doGlobalRead(AstTranslator.WalkContext context, int result, String name) {
        Assertions.UNREACHABLE((String)"doGlobalRead() called for Java code???");
    }

    protected void doGlobalWrite(AstTranslator.WalkContext context, String name, TypeReference type, int rval) {
        Assertions.UNREACHABLE((String)"doGlobalWrite() called for Java code???");
    }

    protected void defineField(CAstEntity topEntity, AstTranslator.WalkContext definingContext, CAstEntity n) {
        assert (topEntity.getKind() == 3);
        assert (n.getKind() == 4);
        IClass owner = this.loader.lookupClass(this.makeType(topEntity.getType()).getName());
        if (owner == null) assert (owner != null) : this.makeType(topEntity.getType()).getName() + " not found in " + this.loader;
        ((JavaSourceLoaderImpl)this.loader).defineField(n, owner);
    }

    protected void declareFunction(CAstEntity N, AstTranslator.WalkContext definingContext) {
        CAstType.Method methodType = (CAstType.Method)N.getType();
        CAstType owningType = methodType.getDeclaringType();
        IClass owner = this.loader.lookupClass(this.makeType(owningType).getName());
        if (owner == null) assert (owner != null) : this.makeType(owningType).getName().toString() + " not found in " + this.loader;
        ((JavaSourceLoaderImpl)this.loader).defineAbstractFunction(N, owner);
    }

    protected void defineFunction(CAstEntity N, AstTranslator.WalkContext definingContext, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
        CAstType.Method methodType = (CAstType.Method)N.getType();
        CAstType owningType = methodType.getDeclaringType();
        TypeName typeName = this.makeType(owningType).getName();
        IClass owner = this.loader.lookupClass(typeName);
        if (owner == null) assert (owner != null) : typeName.toString() + " not found in " + this.loader;
        symtab.getConstant(0);
        symtab.getNullConstant();
        ((JavaSourceLoaderImpl)this.loader).defineFunction(N, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
    }

    protected void doPrimitive(int resultVal, AstTranslator.WalkContext context, CAstNode primitiveCall) {
        Assertions.UNREACHABLE((String)"doPrimitive() called for Java code???");
    }

    protected String composeEntityName(AstTranslator.WalkContext parent, CAstEntity f) {
        switch (f.getKind()) {
            case 3: {
                return parent.getName().length() == 0 ? f.getName() : parent.getName() + "/" + f.getName();
            }
            case 1: {
                return parent.getName() + "/" + f.getSignature();
            }
        }
        return parent.getName();
    }

    private CAstEntity getEnclosingType(CAstEntity entity) {
        if (entity.getQualifiers().contains(CAstQualifier.STATIC)) {
            return null;
        }
        return this.getEnclosingTypeInternal(this.getParent(entity));
    }

    private CAstEntity getEnclosingTypeInternal(CAstEntity entity) {
        switch (entity.getKind()) {
            case 3: {
                return entity;
            }
            case 1: {
                if (entity.getQualifiers().contains(CAstQualifier.STATIC)) {
                    return null;
                }
                return this.getEnclosingTypeInternal(this.getParent(entity));
            }
            case 5: {
                return null;
            }
        }
        return this.getEnclosingTypeInternal(this.getParent(entity));
    }

    protected boolean defineType(CAstEntity type, AstTranslator.WalkContext wc) {
        CAstEntity parentType = this.getEnclosingType(type);
        return ((JavaSourceLoaderImpl)this.loader).defineType(type, type.getType().getName(), parentType) != null;
    }

    protected void leaveThis(CAstNode n, AstTranslator.WalkContext c, CAstVisitor<AstTranslator.WalkContext> visitor) {
        if (n.getChildCount() == 0) {
            super.leaveThis(n, c, visitor);
        } else {
            int result = c.currentScope().allocateTempValue();
            c.setValue(n, result);
            c.cfg().addInstruction((SSAInstruction)new EnclosingObjectReference(c.cfg().getCurrentInstruction(), result, (TypeReference)n.getChild(0).getValue()));
        }
    }

    protected boolean visitCast(CAstNode n, AstTranslator.WalkContext context, CAstVisitor<AstTranslator.WalkContext> visitor) {
        int result = context.currentScope().allocateTempValue();
        context.setValue(n, result);
        return false;
    }

    protected void leaveCast(CAstNode n, AstTranslator.WalkContext context, CAstVisitor<AstTranslator.WalkContext> visitor) {
        int result = context.getValue(n);
        CAstType toType = (CAstType)n.getChild(0).getValue();
        TypeReference toRef = this.makeType(toType);
        CAstType fromType = (CAstType)n.getChild(2).getValue();
        TypeReference fromRef = this.makeType(fromType);
        if (toRef.isPrimitiveType()) {
            context.cfg().addInstruction((SSAInstruction)this.insts.ConversionInstruction(context.cfg().getCurrentInstruction(), result, context.getValue(n.getChild(1)), fromRef, toRef, false));
        } else {
            context.cfg().addInstruction((SSAInstruction)this.insts.CheckCastInstruction(context.cfg().getCurrentInstruction(), result, context.getValue(n.getChild(1)), toRef, true));
            this.processExceptions(n, context);
        }
    }

    protected boolean visitInstanceOf(CAstNode n, AstTranslator.WalkContext context, CAstVisitor<AstTranslator.WalkContext> visitor) {
        int result = context.currentScope().allocateTempValue();
        context.setValue(n, result);
        return false;
    }

    protected void leaveInstanceOf(CAstNode n, AstTranslator.WalkContext context, CAstVisitor<AstTranslator.WalkContext> visitor) {
        int result = context.getValue(n);
        CAstType type = (CAstType)n.getChild(0).getValue();
        TypeReference ref = this.makeType(type);
        context.cfg().addInstruction((SSAInstruction)this.insts.InstanceofInstruction(context.cfg().getCurrentInstruction(), result, context.getValue(n.getChild(1)), ref));
    }

    protected boolean doVisit(CAstNode n, AstTranslator.WalkContext wc, CAstVisitor<AstTranslator.WalkContext> visitor) {
        if (n.getKind() == 23) {
            visitor.visit(n.getChild(0), (CAstVisitor.Context)wc, visitor);
            wc.cfg().addInstruction((SSAInstruction)this.insts.MonitorInstruction(wc.cfg().getCurrentInstruction(), wc.getValue(n.getChild(0)), true));
            this.processExceptions(n, wc);
            return true;
        }
        if (n.getKind() == 24) {
            visitor.visit(n.getChild(0), (CAstVisitor.Context)wc, visitor);
            wc.cfg().addInstruction((SSAInstruction)this.insts.MonitorInstruction(wc.cfg().getCurrentInstruction(), wc.getValue(n.getChild(0)), false));
            this.processExceptions(n, wc);
            return true;
        }
        return super.doVisit(n, (CAstVisitor.Context)wc, visitor);
    }

    private CAstType getType(final String name) {
        return new CAstType.Class(){

            public Collection getSupertypes() {
                return Collections.emptySet();
            }

            public String getName() {
                return name;
            }

            public boolean isInterface() {
                return false;
            }

            public Collection<CAstQualifier> getQualifiers() {
                return Collections.emptySet();
            }
        };
    }

    protected CAstType topType() {
        return this.getType("java.lang.Object");
    }

    protected CAstType exceptionType() {
        return this.getType("java.lang.Exception");
    }
}

