/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr;

import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.ILambdaFormula;
import com.ibm.wala.samso.m2lstr.ITerm;
import com.ibm.wala.samso.m2lstr.IVariable;
import com.ibm.wala.util.functions.Function;
import java.util.HashMap;
import java.util.List;

public class LambdaFormula
implements ILambdaFormula {
    private final IFormula formula;
    private final IVariable[] vars;

    public LambdaFormula(IFormula f, IVariable[] vs) {
        this.formula = f;
        this.vars = vs;
    }

    @Override
    public IFormula getFormula() {
        return this.formula;
    }

    @Override
    public IVariable getVariable(int n) {
        return this.vars[n];
    }

    @Override
    public int getArity() {
        return this.vars.length;
    }

    @Override
    public IFormula apply(ITerm ... args) {
        final HashMap<String, ITerm> m = new HashMap<String, ITerm>();
        for (int i = 0; i < this.vars.length; ++i) {
            m.put(this.vars[i].getName(), args[i]);
        }
        return this.getFormula().replaceTerm(new Function<IVariable, ITerm>(){

            public ITerm apply(IVariable v) {
                String name = v.getName();
                ITerm t = (ITerm)m.get(name);
                return t == null ? v : t;
            }
        });
    }

    public static ILambdaFormula make(IVariable v, IFormula f) {
        return LambdaFormula.make(f, v);
    }

    public static ILambdaFormula make(IFormula f, IVariable ... vs) {
        return new LambdaFormula(f, vs);
    }

    public static ILambdaFormula make(IFormula f, List<IVariable> vs) {
        return new LambdaFormula(f, vs.toArray(new IVariable[vs.size()]));
    }
}

