/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.job;

import com.hcl.appscan.source.scanner.IAction;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.IScanJob;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;

public class AnalysisAction
implements IAction {
    private static final long SLEEP = 5000L;
    private IScanJob m_job;
    private IProgress m_progress;

    public AnalysisAction(IScanJob job, IProgress progress) {
        this.m_job = job;
        this.m_progress = progress;
    }

    @Override
    public void run() throws SourceCodeScannerException {
        this.m_progress.setStatus(new Message(1, Messages.getMessage("run.analysis", new Object[0])));
        this.m_job.execute();
        this.m_progress.setStatus(new Message(1, Messages.getMessage("job.started", this.m_job.getJobId())));
        while (!this.m_job.isComplete()) {
            try {
                Thread.sleep(5000L);
                this.m_job.getStatus();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.m_job.isSuccess()) {
            throw new SourceCodeScannerException(Messages.getMessage("err.run.scan", new Object[0]));
        }
    }

    @Override
    public String getDescription() {
        return Messages.getMessage("action.run.analysis", new Object[0]);
    }
}

