/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.job;

import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.json.JSONObject;

public class RequestHandler {
    private static final String ORIGINATOR = System.getProperty("SASTAGENT") == null ? "test" : System.getProperty("SASTAGENT");
    private static String BASE_URL = System.getProperty("cloudEngineUrl");
    private String m_baseURL;
    private HttpClient m_client = new HttpClient();
    private Map<String, String> m_headers;

    public RequestHandler() {
        this.m_baseURL = BASE_URL;
    }

    public RequestHandler(String url) {
        this.m_baseURL = url;
    }

    public static void checkAnyFailure(HttpResponse response) throws SourceCodeScannerException {
        if (!response.isSuccess()) {
            throw new SourceCodeScannerException(Messages.getMessage("err.http.response", response.getResponseCode(), response.getResponseBodyAsString()));
        }
    }

    private static String removeSlashAsRequired(String initialUrl) {
        if (initialUrl.endsWith("/")) {
            initialUrl = initialUrl.substring(0, initialUrl.length() - 1);
        }
        return initialUrl;
    }

    public HttpResponse executeGetRequest(String path) throws IOException {
        return this.m_client.get(this.m_baseURL + path, this.getHeaders(), null);
    }

    public HttpResponse executePostRequest(String path, JSONObject body) throws IOException {
        return this.m_client.post(this.m_baseURL + path, this.getHeaders(), body.toString().toCharArray());
    }

    private Map<String, String> getHeaders() {
        if (this.m_headers == null) {
            this.m_headers = new HashMap<String, String>();
            this.m_headers.put("accept", "*/*");
            this.m_headers.put("content-type", "application/json");
            this.m_headers.put("X-Originator", ORIGINATOR);
        }
        return this.m_headers;
    }

    static {
        if (BASE_URL == null) {
            BASE_URL = "https://chimera-dev.westeurope.cloudapp.azure.com";
        }
        BASE_URL = RequestHandler.removeSlashAsRequired(BASE_URL);
    }
}

