/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.job;

import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.IScanJob;
import com.hcl.appscan.source.scanner.job.RequestHandler;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerProgress;
import com.hcl.appscan.source.scanner.results.FilteredFile;
import com.hcl.appscan.source.scanner.results.IResult;
import com.hcl.appscan.source.scanner.results.SourceCodeScannerResult;
import com.hcl.appscan.source.scanner.storage.IScanStorage;
import com.hcl.appscan.source.scanner.storage.StorageFactory;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ScanJob
implements IScanJob {
    private File m_scanFile;
    private String m_asocScanId;
    private String m_language;
    private String m_status;
    private String m_jobId;
    private List<String> m_deferredFiles;
    private RequestHandler m_requestHandler;
    private IScanStorage m_storage;
    private IResult m_result;
    private SourceCodeScannerProgress m_progress;
    private boolean m_fatal = false;

    public ScanJob(File scanFile, String asocScanId, String language, SourceCodeScannerProgress progress, String url) {
        this.m_scanFile = scanFile;
        this.m_asocScanId = asocScanId;
        this.m_language = language.equalsIgnoreCase("html") ? Language.LANGUAGE.JAVASCRIPT.toString() : language;
        this.m_progress = progress;
        this.m_storage = StorageFactory.getStorage(this.m_asocScanId, progress.getLogger(), url);
        this.m_requestHandler = url != null ? new RequestHandler(url) : new RequestHandler();
    }

    @Override
    public void execute() throws SourceCodeScannerException {
        String fileId = this.m_storage.storeFile(this.m_scanFile);
        this.submitScanJob(fileId);
    }

    @Override
    public String getStatus() throws SourceCodeScannerException {
        if (!this.isComplete()) {
            this.getScanStatus();
        }
        return this.m_status;
    }

    @Override
    public String getJobId() {
        return this.m_jobId;
    }

    @Override
    public IResult getResult() throws SourceCodeScannerException {
        if (this.m_result == null) {
            this.m_result = new SourceCodeScannerResult(this.m_jobId, this.m_storage, this.m_progress);
        }
        return this.m_result;
    }

    @Override
    public List<String> getDeferredFiles() throws SourceCodeScannerException {
        if (this.m_deferredFiles == null) {
            IResult result = this.getResult();
            this.m_deferredFiles = result.getErrorFiles();
            for (FilteredFile file : result.getFilteredFiles()) {
                if (this.shouldBeSkipped(file)) {
                    String skippedFile = Messages.getMessage("skipped.file", file.getReason(), file.getPath());
                    this.m_progress.getLogger().log(new Message(1, skippedFile));
                    continue;
                }
                this.m_deferredFiles.add(file.getPath());
            }
            this.logDeferredFiles();
        }
        return this.m_deferredFiles;
    }

    @Override
    public boolean isComplete() {
        return "completed".equalsIgnoreCase(this.m_status) || "completed-with-error".equalsIgnoreCase(this.m_status) || "cancelled".equalsIgnoreCase(this.m_status) || "error".equalsIgnoreCase(this.m_status) || "not-found".equalsIgnoreCase(this.m_status);
    }

    @Override
    public boolean isSuccess() {
        return "completed".equalsIgnoreCase(this.m_status) || "completed-with-error".equalsIgnoreCase(this.m_status);
    }

    private void submitScanJob(String fileId) throws SourceCodeScannerException {
        HttpResponse response = this.submitScan(fileId);
        if (!this.checkSubmitScanResponse(response)) {
            this.cancelScan();
            throw new SourceCodeScannerException(Messages.getMessage("err.http.response", response.getResponseCode(), response.getResponseBodyAsString()), this.m_fatal);
        }
    }

    private boolean checkSubmitScanResponse(HttpResponse response) throws SourceCodeScannerException {
        boolean success = true;
        if (response.isBadRequest()) {
            this.m_fatal = true;
            success = false;
        } else if (response.isServerError()) {
            this.m_fatal = false;
            success = false;
        } else if (response.isSuccess()) {
            this.m_fatal = false;
            success = this.checkSubmitScanResponseBody(response);
        }
        return success;
    }

    private boolean checkSubmitScanResponseBody(HttpResponse response) throws SourceCodeScannerException {
        try {
            JSONObject resBody = response.getResponseBody();
            boolean success = resBody.optBoolean("success", true);
            if (!resBody.containsKey((Object)"scanId")) {
                throw new SourceCodeScannerException(Messages.getMessage("err.submit.scan", this.getResponseBodyErrorMessage(resBody)));
            }
            this.m_jobId = resBody.getString("scanId");
            this.m_status = "waiting-to-be-processed";
            return success;
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private HttpResponse submitScan(String fileId) throws SourceCodeScannerException {
        try {
            JSONObject reqBody = new JSONObject();
            reqBody.put("zipSourceFile", (Object)fileId);
            reqBody.put("aSoCScanId", (Object)this.m_asocScanId);
            reqBody.put("languageToScan", (Object)this.m_language);
            reqBody.put("fileChecksumHash", (Object)this.getChecksum());
            return this.m_requestHandler.executePostRequest("/api/v3/Scan/SubmitScan", reqBody);
        }
        catch (IOException | NoSuchAlgorithmException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private void cancelScan() throws SourceCodeScannerException {
        try {
            if (!this.m_fatal) {
                JSONObject reqBody = new JSONObject();
                reqBody.put("scanId", (Object)this.m_jobId);
                this.m_requestHandler.executePostRequest("/api/v3/Scan/CancelScan", reqBody);
            }
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private String getResponseBodyErrorMessage(JSONObject resBody) throws SourceCodeScannerException {
        try {
            return resBody.has("errorMessageDetails") ? resBody.getString("errorMessageDetails") : Messages.getMessage("err.unknown", new Object[0]);
        }
        catch (JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private boolean shouldBeSkipped(FilteredFile file) {
        String reason = file.getReason();
        if (reason == null) {
            return false;
        }
        return reason.equalsIgnoreCase("JSMinified") || reason.equalsIgnoreCase("FileSizeLimit");
    }

    private void getScanStatus() throws SourceCodeScannerException {
        try {
            HttpResponse response = this.m_requestHandler.executeGetRequest("/api/v3/Findings/status/" + this.m_jobId);
            RequestHandler.checkAnyFailure(response);
            JSONObject resBody = response.getResponseBody();
            this.m_status = (String)resBody.getOrDefault((Object)"status", (Object)"running");
        }
        catch (SourceCodeScannerException | IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private void logDeferredFiles() {
        if (this.m_deferredFiles != null && !this.m_deferredFiles.isEmpty()) {
            String deferredList = Messages.getMessage("deferred.files", new Object[0]);
            for (String deferredFile : this.m_deferredFiles) {
                deferredList = deferredList + "\n\t" + deferredFile;
            }
            this.m_progress.getLogger().log(new Message(1, deferredList));
        } else {
            this.m_progress.getLogger().log(new Message(1, Messages.getMessage("deferred.files.empty", new Object[0])));
        }
    }

    private String getChecksum() throws NoSuchAlgorithmException, IOException {
        return SystemUtil.calculateChecksumBase64((File)this.m_scanFile, (String)"MD5");
    }
}

