/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.storage;

import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.RequestHandler;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.storage.BlobStorage;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.ILogManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class BlobResultStorage
extends BlobStorage {
    private String m_jobId;
    private RequestHandler m_handler;

    public BlobResultStorage(String jobId, ILogManager logger) {
        super(jobId, logger, null);
        this.m_jobId = jobId;
        this.m_handler = new RequestHandler();
    }

    public void getScanResult(File destination) throws SourceCodeScannerException {
        try {
            String blobName = this.getBlobName();
            String storageUri = this.getStorageUri(blobName);
            this.getResultFile(storageUri, destination);
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private String getBlobName() throws IOException, JSONException, SourceCodeScannerException {
        try {
            HttpResponse response = this.m_handler.executeGetRequest(String.format("/api/v3/Findings/%s", this.m_jobId));
            RequestHandler.checkAnyFailure(response);
            JSONObject resBody = response.getResponseBody();
            if (!resBody.getBoolean("success")) {
                throw new SourceCodeScannerException(Messages.getMessage("err.get.findings", this.m_jobId, resBody.getString("error")));
            }
            return resBody.getString("findingsBlobName");
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private String getStorageUri(String blobName) throws SourceCodeScannerException {
        try {
            JSONObject reqbody = new JSONObject();
            reqbody.put("blobName", (Object)blobName);
            reqbody.put("scanId", (Object)this.m_jobId);
            HttpResponse response = this.m_handler.executePostRequest("/api/v3/StorageSas/findings", reqbody);
            RequestHandler.checkAnyFailure(response);
            JSONObject resBody = response.getResponseBody();
            return resBody.getString("sasUri");
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private void getResultFile(String uri, File destination) throws SourceCodeScannerException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("cp");
        args.add(this.getQuotedString(uri));
        args.add(this.getQuotedString(destination.getAbsolutePath()));
        args.add("--overwrite=true");
        args.add("--check-length=true");
        this.runAzCopy(args);
    }
}

