/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.storage;

import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.job.RequestHandler;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.storage.BlobStorage;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.ILogManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class BlobScanStorage
extends BlobStorage {
    private String m_fileId;

    public BlobScanStorage(String asocScanId, ILogManager logger, String url) throws SourceCodeScannerException {
        super(asocScanId, logger, url);
    }

    @Override
    public String storeFile(File file) throws SourceCodeScannerException {
        try {
            this.m_fileId = UUID.randomUUID() + ".zip";
            String storageUri = this.initializeStorage();
            this.storeScanFile(file, storageUri);
            return this.m_fileId;
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private String initializeStorage() throws IOException, JSONException, SourceCodeScannerException {
        JSONObject reqBody = new JSONObject();
        reqBody.put("aSoCScanId", (Object)this.getId());
        reqBody.put("blobName", (Object)this.m_fileId);
        RequestHandler requestHandler = this.getUrl() != null ? new RequestHandler(this.getUrl()) : new RequestHandler();
        HttpResponse response = requestHandler.executePostRequest("/api/v3/StorageSas/scans", reqBody);
        RequestHandler.checkAnyFailure(response);
        JSONObject resBody = response.getResponseBody();
        if (resBody.has("sasUri")) {
            return resBody.getString("sasUri");
        }
        String message = resBody.has("errorMessage") ? resBody.getString("errorMessage") : Messages.getMessage("err.unknown", new Object[0]);
        throw new SourceCodeScannerException(Messages.getMessage("err.initialize.storage", message));
    }

    private void storeScanFile(File file, String storageUri) throws SourceCodeScannerException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("cp");
        args.add(this.getQuotedString(file.getAbsolutePath()));
        args.add(this.getQuotedString(storageUri));
        args.add("--overwrite=true");
        args.add("--check-length=true");
        this.runAzCopy(args);
    }
}

