/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;

public class ProgressAdapter
implements IProgress {
    private IScan m_scan;
    private ILogManager m_logManager = CommonCLICore.getLogManager();
    private IConsole m_console = CommonCLICore.getIOConsole();

    public ProgressAdapter() {
        this(null);
    }

    public ProgressAdapter(IScan scan) {
        this.m_scan = scan;
    }

    public void setStatus(Message status) {
        if (this.m_scan != null) {
            this.m_scan.getLogManager().log(status);
        }
        this.m_logManager.log(status);
        this.m_console.println(status);
        if (SystemUtil.IRGenClient.AppScanGo.name().equalsIgnoreCase(System.getenv("APPSCAN_IRGEN_CLIENT"))) {
            if (status.getSeverity() == 4) {
                System.err.println(status.getText());
            } else {
                System.out.println(status.getText());
            }
        }
    }

    public void resetStatus() {
    }

    public boolean isCanceled() {
        return false;
    }
}

